/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.path;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.view.animation.DecelerateInterpolator;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class SearchPathBuilder
extends ZLoadingBuilder {
    private static final int FINAL_STATE = 3;
    private int mCurrAnimatorState = 0;
    private float mR;
    private Paint mPaint;
    private Path mPath;
    private Path mPathZoom;
    private PathMeasure mPathMeasure;
    private Path mDrawPath;

    @Override
    protected void initParams(Context context) {
        this.mR = this.getAllSize();
        this.initPaint();
        this.initPathMeasure();
        this.initPaths();
    }

    private void initPaint() {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(15.0f);
        this.mPaint.setColor(-16777216);
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
    }

    private void initPaths() {
        float r = this.mR * 0.4f;
        this.mPath = new Path();
        this.mPath.addArc(new RectF(this.getViewCenterX() - this.mR, this.getViewCenterY() - this.mR, this.getViewCenterX() + this.mR, this.getViewCenterY() + this.mR), 45.0f, 359.9f);
        this.mPathMeasure.setPath(this.mPath, false);
        float[] pos = new float[2];
        this.mPathMeasure.getPosTan(0.0f, pos, null);
        this.mPathZoom = new Path();
        this.mPathZoom.addArc(new RectF(this.getViewCenterX() - r, this.getViewCenterY() - r, this.getViewCenterX() + r, this.getViewCenterY() + r), 45.0f, 359.9f);
        this.mPathZoom.lineTo(pos[0], pos[1]);
    }

    private void initPathMeasure() {
        this.mDrawPath = new Path();
        this.mPathMeasure = new PathMeasure();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.drawPath(this.mDrawPath, this.mPaint);
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
        floatValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        switch (this.mCurrAnimatorState) {
            case 0: 
            case 1: {
                this.resetDrawPath();
                this.mPathMeasure.setPath(this.mPath, false);
                float stop = this.mPathMeasure.getLength() * animatedValue;
                float start = (float)((double)stop - (0.5 - Math.abs((double)animatedValue - 0.5)) * 200.0);
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
            case 2: {
                this.resetDrawPath();
                this.mPathMeasure.setPath(this.mPath, false);
                float stop = this.mPathMeasure.getLength() * animatedValue;
                float start = 0.0f;
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
            case 3: {
                this.mPathMeasure.setPath(this.mPathZoom, false);
                float stop = this.mPathMeasure.getLength();
                float start = stop * (1.0f - animatedValue);
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
        }
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 3) {
            this.mCurrAnimatorState = 0;
        }
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    private void resetDrawPath() {
        this.mDrawPath.reset();
        this.mDrawPath.lineTo(0.0f, 0.0f);
    }
}

