/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.path;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.view.animation.DecelerateInterpolator;
import com.zyao89.view.zloading.base.BaseStateBuilder;

public class StairsPathBuilder
extends BaseStateBuilder {
    private final int FLOOR_NUM = 6;
    private Paint mPaint;
    private float mR;
    private Path mPath;
    private Path mPathFinal;
    private PathMeasure mPathMeasure;
    private Path mDrawPath;

    @Override
    protected int getStateCount() {
        return 3;
    }

    @Override
    protected void initParams(Context context, Paint paint) {
        this.mPaint = paint;
        this.mR = this.getAllSize();
        this.initPathMeasure();
        this.initPaths();
    }

    private void initPaths() {
        this.mPath = new Path();
        float space = this.mR * 2.0f / 6.0f;
        float startXP = this.getViewCenterX() - this.mR;
        float startYP = this.getViewCenterY() + this.mR;
        this.mPath.moveTo(startXP, startYP);
        for (int i = 0; i < 6; ++i) {
            this.mPath.lineTo((float)i * space + startXP, startYP - space * (float)(i + 1));
            this.mPath.lineTo((float)(i + 1) * space + startXP, startYP - space * (float)(i + 1));
        }
        this.mPathFinal = new Path(this.mPath);
        this.mPathFinal.lineTo(6.0f * space + startXP, startYP);
        this.mPathFinal.lineTo(startXP, startYP);
    }

    private void initPathMeasure() {
        this.mDrawPath = new Path();
        this.mPathMeasure = new PathMeasure();
    }

    @Override
    protected void onComputeUpdateValue(ValueAnimator animation, float animatedValue, int state) {
        switch (state) {
            case 0: 
            case 1: {
                this.resetDrawPath();
                this.mPathMeasure.setPath(this.mPath, false);
                float stop = this.mPathMeasure.getLength() * animatedValue;
                float start = (float)((double)stop - (0.5 - Math.abs((double)animatedValue - 0.5)) * 200.0);
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
            case 2: {
                this.resetDrawPath();
                this.mPathMeasure.setPath(this.mPathFinal, false);
                float stop = this.mPathMeasure.getLength() * animatedValue;
                float start = 0.0f;
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
            case 3: {
                this.resetDrawPath();
                this.mPathMeasure.setPath(this.mPathFinal, false);
                float stop = this.mPathMeasure.getLength() * (1.0f - animatedValue);
                float start = 0.0f;
                this.mPathMeasure.getSegment(start, stop, this.mDrawPath, true);
                break;
            }
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.drawPath(this.mDrawPath, this.mPaint);
    }

    @Override
    protected void prepareStart(ValueAnimator valueAnimator) {
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
    }

    @Override
    protected void prepareEnd() {
    }

    private void resetDrawPath() {
        this.mDrawPath.reset();
        this.mDrawPath.lineTo(0.0f, 0.0f);
    }
}

