/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.rect;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.zyao89.view.zloading.base.BaseStateBuilder;

public class ChartRectBuilder
extends BaseStateBuilder {
    private final int SUM_NUM = 5;
    private volatile long mAnimateDurationTime = 500L;
    private volatile int mCurrStateNum = 0;
    private volatile float mCurrAnimatedValue = 0.0f;
    private Paint mPaint;
    private float mR;
    private RectF mStairRectF;

    @Override
    protected int getStateCount() {
        return 6;
    }

    @Override
    protected void initParams(Context context, Paint paint) {
        this.mPaint = paint;
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mR = this.getAllSize();
        this.mStairRectF = new RectF();
    }

    @Override
    protected void onComputeUpdateValue(ValueAnimator animation, float animatedValue, int state) {
        this.mCurrStateNum = state;
        this.mCurrAnimatedValue = animatedValue;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        float floorHeight = this.mR * 2.0f / 5.0f;
        float space = floorHeight * 0.5f;
        float startXP = this.getViewCenterX() - this.mR;
        float startYP = this.getViewCenterY() + this.mR;
        this.mStairRectF.setEmpty();
        for (int i = 0; i < 5 && i <= this.mCurrStateNum; ++i) {
            float offsetHV = (0.5f - Math.abs(this.mCurrAnimatedValue - 0.5f)) * floorHeight;
            int j = i % 3;
            if (i == this.mCurrStateNum) {
                this.mStairRectF.set(startXP + (float)i * floorHeight, startYP - (float)(j + 1) * floorHeight * this.mCurrAnimatedValue, startXP + (float)(i + 1) * floorHeight - space, startYP);
            } else {
                this.mStairRectF.set(startXP + (float)i * floorHeight, startYP - (float)(j + 1) * floorHeight - offsetHV, startXP + (float)(i + 1) * floorHeight - space, startYP);
            }
            canvas.drawRect(this.mStairRectF, this.mPaint);
        }
    }

    @Override
    protected void prepareStart(ValueAnimator animation) {
        this.mAnimateDurationTime = ChartRectBuilder.ceil((double)this.getAnimationDuration() * 0.4);
        animation.setDuration(this.mAnimateDurationTime);
    }

    @Override
    protected void prepareEnd() {
        this.mCurrStateNum = 0;
        this.mCurrAnimatedValue = 0.0f;
    }
}

