/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.rect;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.animation.DecelerateInterpolator;
import com.zyao89.view.zloading.base.BaseStateBuilder;

public class StairsRectBuilder
extends BaseStateBuilder {
    private final int FLOOR_NUM = 5;
    private volatile long mAnimateDurationTime = 500L;
    private volatile int mCurrFloorNum = 0;
    private volatile float mCurrAnimatedValue = 0.0f;
    private Paint mPaint;
    private float mR;
    private RectF mStairRectF;

    @Override
    protected int getStateCount() {
        return 5;
    }

    @Override
    protected void initParams(Context context, Paint paint) {
        this.mPaint = paint;
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mR = this.getAllSize();
        this.mStairRectF = new RectF();
    }

    @Override
    protected void onComputeUpdateValue(ValueAnimator animation, float animatedValue, int state) {
        this.mCurrFloorNum = state;
        this.mCurrAnimatedValue = animatedValue;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        float floorHeight = this.mR * 2.0f / 5.0f;
        float space = floorHeight * 0.5f;
        float startXP = this.getViewCenterX() - this.mR;
        float startYP = this.getViewCenterY() + this.mR;
        this.mStairRectF.setEmpty();
        for (int i = 0; i < 5 && i <= this.mCurrFloorNum; ++i) {
            if (i == this.mCurrFloorNum) {
                this.mStairRectF.set(startXP, startYP - (float)(i + 1) * floorHeight + space, (startXP + (float)(i + 1) * floorHeight) * this.mCurrAnimatedValue, startYP - (float)i * floorHeight);
            } else {
                this.mStairRectF.set(startXP, startYP - (float)(i + 1) * floorHeight + space, startXP + (float)(i + 1) * floorHeight, startYP - (float)i * floorHeight);
            }
            canvas.drawRect(this.mStairRectF, this.mPaint);
        }
    }

    @Override
    protected void prepareStart(ValueAnimator animation) {
        this.mAnimateDurationTime = StairsRectBuilder.ceil((double)this.getAnimationDuration() * 0.5);
        animation.setDuration(this.mAnimateDurationTime);
        animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
    }

    @Override
    protected void prepareEnd() {
        this.mCurrFloorNum = 0;
        this.mCurrAnimatedValue = 0.0f;
    }
}

