/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.star;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.FloatRange;
import android.view.animation.DecelerateInterpolator;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class LeafBuilder
extends ZLoadingBuilder {
    private static final int FINAL_STATE = 2;
    private Paint mFullPaint;
    private float mStarOutR;
    private float mStarInR;
    private float mStarOutMidR;
    private float mStarInMidR;
    private float mCenterCircleR;
    private int mRotateAngle;
    private int mCurrAnimatorState = 0;
    private Path mStarPath;

    @Override
    protected void initParams(Context context) {
        this.initPaint();
        this.mStarOutR = this.getAllSize();
        this.mStarOutMidR = this.mStarOutR * 0.9f;
        this.mStarInR = this.mStarOutR * 0.7f;
        this.mStarInMidR = this.mStarOutR * 0.3f;
        this.mCenterCircleR = LeafBuilder.dip2px(context, 3.0f);
        this.mRotateAngle = 0;
        this.mStarPath = new Path();
    }

    private void initPaint() {
        this.mFullPaint = new Paint(1);
        this.mFullPaint.setStyle(Paint.Style.FILL);
        this.mFullPaint.setStrokeWidth(2.0f);
        this.mFullPaint.setColor(-1);
        this.mFullPaint.setDither(true);
        this.mFullPaint.setFilterBitmap(true);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.rotate((float)this.mRotateAngle, this.getViewCenterX(), this.getViewCenterY());
        this.createStarPath(this.mStarPath, 5, -18);
        this.mStarPath.addCircle(this.getViewCenterX(), this.getViewCenterY(), this.mCenterCircleR, Path.Direction.CW);
        this.mStarPath.setFillType(Path.FillType.EVEN_ODD);
        canvas.drawPath(this.mStarPath, this.mFullPaint);
        canvas.restore();
    }

    private void createStarPath(Path path, int num, int startAngle) {
        path.reset();
        int angle = 360 / num;
        int roundSize = 5;
        int offsetAngle = angle / 2;
        path.moveTo(this.getViewCenterX() + this.mStarOutMidR * this.cos(startAngle - roundSize), this.getViewCenterY() + this.mStarOutMidR * this.sin(startAngle - roundSize));
        for (int i = 0; i < num; ++i) {
            int value = angle * i + startAngle;
            path.lineTo(this.getViewCenterX() + this.mStarOutMidR * this.cos(value - roundSize), this.getViewCenterY() + this.mStarOutMidR * this.sin(value - roundSize));
            path.quadTo(this.getViewCenterX() + this.mStarOutR * this.cos(value), this.getViewCenterY() + this.mStarOutR * this.sin(value), this.getViewCenterX() + this.mStarOutMidR * this.cos(value + roundSize), this.getViewCenterY() + this.mStarOutMidR * this.sin(value + roundSize));
            path.lineTo(this.getViewCenterX() + this.mStarInR * this.cos(value + offsetAngle - roundSize), this.getViewCenterY() + this.mStarInR * this.sin(value + offsetAngle - roundSize));
            path.quadTo(this.getViewCenterX() + this.mStarInMidR * this.cos(value + offsetAngle), this.getViewCenterY() + this.mStarInMidR * this.sin(value + offsetAngle), this.getViewCenterX() + this.mStarInR * this.cos(value + offsetAngle + roundSize), this.getViewCenterY() + this.mStarInR * this.sin(value + offsetAngle + roundSize));
        }
        path.close();
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mFullPaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
        floatValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        switch (this.mCurrAnimatorState) {
            case 0: {
                this.mStarOutMidR = this.getAllSize() * animatedValue;
                this.mRotateAngle = (int)(360.0f * animatedValue);
                break;
            }
            case 1: {
                this.mRotateAngle = (int)(360.0f * (1.0f - animatedValue));
                break;
            }
            case 2: {
                this.mStarOutMidR = this.getAllSize() * (1.0f - animatedValue);
            }
        }
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (++this.mCurrAnimatorState > 2) {
            this.mCurrAnimatorState = 0;
        }
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mFullPaint.setColorFilter(colorFilter);
    }

    protected final float cos(int num) {
        return (float)Math.cos((double)num * Math.PI / 180.0);
    }

    protected final float sin(int num) {
        return (float)Math.sin((double)num * Math.PI / 180.0);
    }
}

