/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.star;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class StarBuilder
extends ZLoadingBuilder {
    private Paint mFullPaint;
    private float mStarOutR;
    private float mStarInR;
    private float mStarOutMidR;
    private float mStarInMidR;
    private int mStartAngle;
    private Path mStarPath;
    private float mOffsetTranslateY;
    private RectF mOvalRectF;
    private float mShadowWidth;
    private ValueAnimator mShadowAnimator;
    private final ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            StarBuilder.this.mOffsetTranslateY = StarBuilder.this.getViewCenterY() * 0.4f * value;
            StarBuilder.this.mShadowWidth = (StarBuilder.this.mOffsetTranslateY + 10.0f) * 0.9f;
        }
    };

    @Override
    protected void initParams(Context context) {
        this.mFullPaint = new Paint(1);
        this.mFullPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mFullPaint.setStrokeWidth(2.0f);
        this.mFullPaint.setColor(-16777216);
        this.mFullPaint.setDither(true);
        this.mFullPaint.setFilterBitmap(true);
        this.initValue(context);
        this.initAnimator();
    }

    private void initAnimator() {
        this.mShadowAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f, 0.0f});
        this.mShadowAnimator.setRepeatCount(-1);
        this.mShadowAnimator.setDuration(this.getAnimationDuration());
        this.mShadowAnimator.setStartDelay(this.getAnimationStartDelay());
        this.mShadowAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
    }

    private void initValue(Context context) {
        float allSize = this.getAllSize();
        this.mStarOutR = allSize - StarBuilder.dip2px(context, 5.0f);
        this.mStarOutMidR = this.mStarOutR * 0.9f;
        this.mStarInR = this.mStarOutMidR * 0.6f;
        this.mStarInMidR = this.mStarInR * 0.9f;
        this.mStartAngle = 0;
        this.mOffsetTranslateY = 0.0f;
        this.mStarPath = this.createStarPath(5, -18);
        this.mShadowWidth = this.mStarOutR;
        this.mOvalRectF = new RectF();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.save();
        canvas.translate(0.0f, this.mOffsetTranslateY);
        canvas.rotate((float)this.mStartAngle, this.getViewCenterX(), this.getViewCenterY());
        canvas.drawPath(this.mStarPath, this.mFullPaint);
        canvas.restore();
        this.mOvalRectF.set(this.getViewCenterX() - this.mShadowWidth, this.getIntrinsicHeight() - 20.0f, this.getViewCenterX() + this.mShadowWidth, this.getIntrinsicHeight() - 10.0f);
        canvas.drawOval(this.mOvalRectF, this.mFullPaint);
    }

    private Path createStarPath(int num, int startAngle) {
        Path path = new Path();
        int angle = 360 / num;
        int roundSize = 5;
        int offsetAngle = angle / 2;
        path.moveTo(this.getViewCenterX() + this.mStarOutMidR * this.cos(startAngle - roundSize), this.getViewCenterY() + this.mStarOutMidR * this.sin(startAngle - roundSize));
        for (int i = 0; i < num; ++i) {
            int value = angle * i + startAngle;
            path.lineTo(this.getViewCenterX() + this.mStarOutMidR * this.cos(value - roundSize), this.getViewCenterY() + this.mStarOutMidR * this.sin(value - roundSize));
            path.quadTo(this.getViewCenterX() + this.mStarOutR * this.cos(value), this.getViewCenterY() + this.mStarOutR * this.sin(value), this.getViewCenterX() + this.mStarOutMidR * this.cos(value + roundSize), this.getViewCenterY() + this.mStarOutMidR * this.sin(value + roundSize));
            path.lineTo(this.getViewCenterX() + this.mStarInR * this.cos(value + offsetAngle - roundSize), this.getViewCenterY() + this.mStarInR * this.sin(value + offsetAngle - roundSize));
            path.quadTo(this.getViewCenterX() + this.mStarInMidR * this.cos(value + offsetAngle), this.getViewCenterY() + this.mStarInMidR * this.sin(value + offsetAngle), this.getViewCenterX() + this.mStarInR * this.cos(value + offsetAngle + roundSize), this.getViewCenterY() + this.mStarInR * this.sin(value + offsetAngle + roundSize));
        }
        path.close();
        return path;
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mFullPaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
        floatValueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mShadowAnimator.setRepeatCount(-1);
        this.mShadowAnimator.setDuration(this.getAnimationDuration());
        this.mShadowAnimator.setStartDelay(this.getAnimationStartDelay());
        this.mShadowAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mShadowAnimator.start();
    }

    @Override
    protected void prepareEnd() {
        this.mShadowAnimator.removeAllUpdateListeners();
        this.mShadowAnimator.removeAllListeners();
        this.mShadowAnimator.setRepeatCount(0);
        this.mShadowAnimator.setDuration(0L);
        this.mShadowAnimator.end();
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        this.mStartAngle = (int)(360.0f * animatedValue);
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mFullPaint.setColorFilter(colorFilter);
    }

    protected final float cos(int num) {
        return (float)Math.cos((double)num * Math.PI / 180.0);
    }

    protected final float sin(int num) {
        return (float)Math.sin((double)num * Math.PI / 180.0);
    }
}

