/*
 * Decompiled with CFR 0.152.
 */
package com.zyao89.view.zloading.text;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.support.annotation.FloatRange;
import android.text.TextUtils;
import android.view.animation.AccelerateInterpolator;
import com.zyao89.view.zloading.ZLoadingBuilder;

public class TextBuilder
extends ZLoadingBuilder {
    private static final int BASE_ALPHA = 100;
    private static final String DEFAULT_TEXT = "Zyao89";
    private Paint mTextPaint;
    private String mTextChars;
    private int mDrawTextCount = 0;

    @Override
    protected void initParams(Context context) {
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(-16777216);
        this.mTextPaint.setDither(true);
        this.mTextPaint.setFilterBitmap(true);
        this.mTextPaint.setTextSize(this.getAllSize());
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.mTextChars = DEFAULT_TEXT;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.isNotEmpty()) {
            int length = this.mTextChars.toCharArray().length;
            float measureText = this.mTextPaint.measureText(this.mTextChars, 0, length);
            Paint paint = new Paint(this.mTextPaint);
            paint.setAlpha(100);
            canvas.drawText(this.mTextChars, 0, length, this.getViewCenterX() - measureText / 2.0f, this.getViewCenterY(), paint);
            canvas.drawText(this.mTextChars, 0, this.mDrawTextCount, this.getViewCenterX() - measureText / 2.0f, this.getViewCenterY(), this.mTextPaint);
        }
    }

    @Override
    protected void setAlpha(int alpha) {
        this.mTextPaint.setAlpha(alpha);
    }

    @Override
    protected void prepareStart(ValueAnimator floatValueAnimator) {
        floatValueAnimator.setDuration(TextBuilder.ceil((float)this.getAnimationDuration() * 0.3f));
        floatValueAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
    }

    @Override
    protected void prepareEnd() {
    }

    @Override
    protected void computeUpdateValue(ValueAnimator animation, @FloatRange(from=0.0, to=1.0) float animatedValue) {
        this.mTextPaint.setAlpha((int)(animatedValue * 155.0f) + 100);
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
        if (this.isNotEmpty() && ++this.mDrawTextCount > this.mTextChars.toCharArray().length) {
            this.mDrawTextCount = 0;
        }
    }

    @Override
    protected void setColorFilter(ColorFilter colorFilter) {
        this.mTextPaint.setColorFilter(colorFilter);
    }

    public void setText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        float measureText = this.mTextPaint.measureText(text);
        if (measureText >= this.getIntrinsicWidth()) {
            float v = measureText / this.getAllSize();
            this.mTextPaint.setTextSize(this.getIntrinsicWidth() / v);
        }
        this.mTextChars = text;
    }

    private boolean isNotEmpty() {
        return this.mTextChars != null && !this.mTextChars.isEmpty();
    }
}

