/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services.endpoints;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.Endpoints;
import de.codecentric.boot.admin.server.services.endpoints.EndpointDetectionStrategy;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ChainingStrategy
implements EndpointDetectionStrategy {
    private EndpointDetectionStrategy[] delegates;

    public ChainingStrategy(EndpointDetectionStrategy ... delegates) {
        Assert.notNull((Object)delegates, (String)"'delegates' must not be null.");
        Assert.noNullElements((Object[])delegates, (String)"'delegates' must not contain null.");
        this.delegates = delegates;
    }

    @Override
    public Mono<Endpoints> detectEndpoints(Instance instance) {
        Mono result = Mono.empty();
        for (EndpointDetectionStrategy delegate : this.delegates) {
            result = result.switchIfEmpty(delegate.detectEndpoints(instance));
        }
        return result.switchIfEmpty(Mono.just((Object)Endpoints.empty()));
    }
}

