/*
 * Decompiled with CFR 0.152.
 */
package jcifs.context;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.RuntimeCIFSException;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonContext
extends BaseContext
implements CIFSContext {
    private static final Logger log = LoggerFactory.getLogger(SingletonContext.class);
    private static SingletonContext INSTANCE;

    public static final synchronized void init(Properties props) throws CIFSException {
        Properties p;
        block16: {
            if (INSTANCE != null) {
                throw new CIFSException("Singleton context is already initialized");
            }
            p = new Properties();
            try {
                String filename = System.getProperty("jcifs.properties");
                if (filename == null || filename.length() <= 1) break block16;
                try (FileInputStream in = new FileInputStream(filename);){
                    p.load(in);
                }
            }
            catch (IOException ioe) {
                log.error("Failed to load config", (Throwable)ioe);
            }
        }
        p.putAll((Map<?, ?>)System.getProperties());
        if (props != null) {
            p.putAll((Map<?, ?>)props);
        }
        INSTANCE = new SingletonContext(p);
    }

    public static final synchronized SingletonContext getInstance() {
        if (INSTANCE == null) {
            try {
                log.debug("Initializing singleton context");
                SingletonContext.init(null);
            }
            catch (CIFSException e) {
                log.error("Failed to create singleton JCIFS context", (Throwable)e);
            }
        }
        return INSTANCE;
    }

    public static void registerSmbURLHandler() {
        float ver = Float.parseFloat(Runtime.class.getPackage().getSpecificationVersion());
        String vendor = System.getProperty("java.vendor.url");
        if ((vendor == null || !vendor.startsWith("http://www.android.com")) && ver < 1.7f) {
            throw new RuntimeCIFSException("jcifs-ng requires Java 1.7 or above. You are running " + ver);
        }
        SingletonContext.getInstance();
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null) {
            System.setProperty("java.protocol.handler.pkgs", "jcifs");
        } else if (pkgs.indexOf("jcifs") == -1) {
            pkgs = pkgs + "|jcifs";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        }
    }

    private SingletonContext(Properties p) throws CIFSException {
        super(new PropertyConfiguration(p));
    }
}

