/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans.nt;

import jcifs.Configuration;
import jcifs.internal.smb1.trans.nt.SmbComNtTransaction;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class NtTransQuerySecurityDesc
extends SmbComNtTransaction {
    int fid;
    int securityInformation;

    public NtTransQuerySecurityDesc(Configuration config, int fid, int securityInformation) {
        super(config, 6);
        this.fid = fid;
        this.securityInformation = securityInformation;
        this.setupCount = 0;
        this.totalDataCount = 0;
        this.maxParameterCount = 4;
        this.maxDataCount = 65536;
        this.maxSetupCount = 0;
    }

    @Override
    public int getPadding() {
        return 4;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.fid, dst, dstIndex);
        dstIndex += 2;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        SMBUtil.writeInt4(this.securityInformation, dst, dstIndex);
        return (dstIndex += 4) - start;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("NtTransQuerySecurityDesc[" + super.toString() + ",fid=0x" + Hexdump.toHexString(this.fid, 4) + ",securityInformation=0x" + Hexdump.toHexString(this.securityInformation, 8) + "]");
    }
}

