/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.io;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.util.SMBUtil;

public class Smb2ReadResponse
extends ServerMessageBlock2Response {
    public static final int OVERHEAD = 80;
    private int dataRemaining;
    private int dataLength;
    private byte[] outputBuffer;
    private int outputBufferOffset;

    public Smb2ReadResponse(Configuration config, byte[] outputBuffer, int outputBufferOffset) {
        super(config);
        this.outputBuffer = outputBuffer;
        this.outputBufferOffset = outputBufferOffset;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getDataRemaining() {
        return this.dataRemaining;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize == 9) {
            return this.readErrorResponse(buffer, bufferIndex);
        }
        if (structureSize != 17) {
            throw new SMBProtocolDecodingException("Expected structureSize = 17");
        }
        short dataOffset = buffer[bufferIndex + 2];
        this.dataLength = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.dataRemaining = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        bufferIndex += 4;
        int dataStart = this.getHeaderStart() + dataOffset;
        if (this.dataLength + this.outputBufferOffset > this.outputBuffer.length) {
            throw new SMBProtocolDecodingException("Buffer to small for read response");
        }
        System.arraycopy(buffer, dataStart, this.outputBuffer, this.outputBufferOffset, this.dataLength);
        bufferIndex = Math.max(bufferIndex, dataStart + this.dataLength);
        return bufferIndex - start;
    }

    @Override
    protected boolean isErrorResponseStatus() {
        return this.getStatus() != -2147483643 && super.isErrorResponseStatus();
    }
}

