/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal;

import android.graphics.SurfaceTexture;
import android.view.SurfaceHolder;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglRenderer;
import io.agora.base.internal.video.RendererCommon;

public class SurfaceEglRenderer
extends EglRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "SurfaceEglRenderer";
    private final Object layoutLock = new Object();
    private boolean isRenderingPaused = false;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;

    public SurfaceEglRenderer(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int transfer, RendererCommon.GlDrawer drawer, boolean useVsync) {
        this.rendererEvents = rendererEvents;
        Object object = this.layoutLock;
        synchronized (object) {
            this.isFirstFrameRendered = false;
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        super.init(sharedContext, transfer, drawer, useVsync);
    }

    @Override
    public void init(EglBase.Context sharedContext, int transfer, RendererCommon.GlDrawer drawer, boolean useVsync) {
        this.init(sharedContext, null, transfer, drawer, useVsync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFpsReduction(float fps) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = fps == 0.0f;
        }
        super.setFpsReduction(fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableFpsReduction() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
        }
        super.disableFpsReduction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseVideo() {
        Object object = this.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
        }
        super.pauseVideo();
    }

    @Override
    public void onFrame(VideoFrame frame) {
        this.updateFrameDimensionsAndReportEvents(frame);
        super.onFrame(frame);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.logD("surfaceCreated: SurfaceHolder: " + holder);
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(holder.getSurface());
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.logD("surfaceDestroyed: SurfaceHolder: " + holder);
        ThreadUtils.checkIsOnMainThread();
        this.releaseEglSurface();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        this.logD("surfaceChanged: format: " + format + " size: " + width + "x" + height);
        this.notifySurfaceSizeChanged();
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        this.logD("onTextureSurfaceAvailable: surfaceTexture: " + surfaceTexture + " width: " + width + "height" + height);
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(surfaceTexture);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        this.logD("onSurfaceTextureSizeChanged: surfaceTexture: " + surfaceTexture + " size: " + width + "x" + height);
        this.notifySurfaceSizeChanged();
    }

    public void onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.logD("onSurfaceTextureDestroyed: surfaceTexture: " + surfaceTexture);
        ThreadUtils.checkIsOnMainThread();
        this.releaseEglSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.isRenderingPaused) {
                return;
            }
            if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight() || this.frameRotation != frame.getRotation()) {
                this.logD("Reporting frame resolution changed to " + frame.getBuffer().getWidth() + "x" + frame.getBuffer().getHeight() + " with rotation " + frame.getRotation());
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation());
                }
                this.rotatedFrameWidth = frame.getRotatedWidth();
                this.rotatedFrameHeight = frame.getRotatedHeight();
                this.frameRotation = frame.getRotation();
            }
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + ": " + string);
    }
}

