/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Range;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.BitrateAdjuster;
import io.agora.base.internal.video.BitrateAdjusterHelper;
import io.agora.base.internal.video.CodecSpecificInfo;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBase10;
import io.agora.base.internal.video.EglBase14;
import io.agora.base.internal.video.EncodedImage;
import io.agora.base.internal.video.FactorBitrateAdjuster;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.MediaCodecUtils;
import io.agora.base.internal.video.MediaCodecWrapper;
import io.agora.base.internal.video.MediaCodecWrapperFactory;
import io.agora.base.internal.video.VideoCodecStatus;
import io.agora.base.internal.video.VideoCodecType;
import io.agora.base.internal.video.VideoEncoder;
import io.agora.base.internal.video.VideoEncoderUtils;
import io.agora.base.internal.video.VideoEncoderWrapper;
import io.agora.base.internal.video.VideoFrameDrawer;
import io.agora.base.internal.video.YuvHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=19)
public class HardwareVideoEncoder
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final boolean debug = false;
    private static final String KEY_AV_ENC_VIDEO_WIDTH_ALIGNMENT = "av_enc_video_width_alignment";
    private static final String KEY_AV_ENC_VIDEO_HEIGHT_ALIGNMENT = "av_enc_video_height_alignment";
    private static final String KEY_AV_ENC_VIDEO_FORCE_ALIGNMENT = "av_enc_video_force_alignment";
    private static final String KEY_AV_ENC_VIDEO_ADJUSTMENT_RESET = "av_enc_video_adjustment_reset";
    private static final String KEY_AV_ENC_VIDEO_ENABLE_DEQUEUE_TIMEWAIT = "av_enc_video_enable_dequeue_timewait";
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int VIDEO_ControlRateVariable = 1;
    private static final int VIDEO_ControlQualityConstant = 0;
    private static final String KEY_BITRATE_MODE = "bitrate-mode";
    private static final int VIDEO_AVC_PROFILE_HIGH = 8;
    private static final int VIDEO_AVC_LEVEL_3_1 = 512;
    private static final int VIDEO_HEVC_PROFILE_MAIN = 1;
    private static final int VIDEO_HEVC_MAINLEVEL_31 = 256;
    private static final int MAX_VIDEO_FRAMERATE = 60;
    private static final int MIN_VIDEO_FRAMERATE = 2;
    private static final int MAX_ENCODER_Q_SIZE = 5;
    private static final int MAX_NO_INPUT_LIMIT = 5;
    private static final int MAX_ENCODER_Q_WAIT_TIMEOUT_MS = 2000;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEWAIT_US = 0;
    private static final int MAX_ENCODE_TIME_MS = 2000;
    private static final int DEFAULT_WIDTH_ALIGNMENT = 16;
    private static final int DEFAULT_HEIGHT_ALIGNMENT = 4;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private int maxSupportedWidth = 32768;
    private int maxSupportedHeight = 32768;
    private int minSupportedWidth = 2;
    private int minSupportedHeight = 2;
    private int maxSupportedBitrate = 0;
    private int minSupportedBitrate = 0;
    private int widthAlignment = 16;
    private int heightAlignment = 4;
    private boolean forceAlignment = true;
    private volatile boolean forceDequeueTimeWait = false;
    private final VideoCodecType codecType;
    private final Integer surfaceColorFormat;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final Map<String, String> params;
    private int keyFrameIntervalSec;
    @Nullable
    private String profileLevelId = "";
    private final long forcedKeyFrameNs;
    @Nullable
    private volatile VideoEncoderUtils.SupportCodecInfo supportCodecInfo;
    private int bitrateAdjustment;
    private final BitrateAdjuster bitrateAdjuster;
    @Nullable
    private EglBase.Context sharedContext;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private final BlockingDeque<EncodedImage.Builder> outputBuilders = new LinkedBlockingDeque<EncodedImage.Builder>();
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    @Nullable
    private String customConfigJson;
    private long lastPresentationTimestampUs = 0L;
    private final Queue<TimeStamps> encodeTimeStamps = new ConcurrentLinkedQueue<TimeStamps>();
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    @Nullable
    private MediaCodecWrapper codec;
    @Nullable
    private Thread outputThread;
    @Nullable
    private Handler proxyThreadHandler;
    @Nullable
    private EglBase textureEglBase;
    @Nullable
    private Surface textureInputSurface;
    private int width;
    private int height;
    private int alignedWidth;
    private int alignedHeight;
    private int bitrateMode;
    private int maxFramerate;
    private boolean useSurfaceMode;
    private boolean shouldUseBaseline;
    private boolean shouldFallbackSoftware;
    private boolean shouldResetCodec;
    private boolean deliveredVideoFrame;
    private long lastKeyFrameNs;
    @Nullable
    private ByteBuffer configBuffer = null;
    private int adjustedBitrate;
    private volatile boolean running = false;
    @Nullable
    private volatile Exception shutdownException = null;
    private Map<Long, CodecSpecificInfo> codecSpecificInfoMap = new ConcurrentHashMap<Long, CodecSpecificInfo>();
    private static Map<String, Boolean> codecUnavailableMap = new ConcurrentHashMap<String, Boolean>();
    @Nullable
    private VideoEncoder.EncoderStyle encoderStyle;
    private long firstEncoderQueueFullMs = -1L;
    private int inputDropCount;
    @VisibleForTesting
    private static boolean mockEncoderQueueFull = false;
    private static final int kMaxVuiSpsIncrease = 64;
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4", "P6-C00", "HM 2A", "XT105", "XT109", "XT1060"};
    private static final String[] INTERVAL_HW_EXCEPTION_MODELS = new String[]{"vivo X21A", "MI 8", "MI 6", "MI 8 Lite", "Redmi Note 7"};
    private static final int INT_SETTING_INTERVAL_VALUE = 10;
    private static final int INT_PERIODIC_I_FRAME_INTERVAL_VALUE = 2;
    private static final int INT_INTERVAL_UPPER_LIMIT = 100;

    @VisibleForTesting
    public static void setMockEncoderQueueFull(boolean mockEncoderQueueFull) {
        HardwareVideoEncoder.mockEncoderQueueFull = mockEncoderQueueFull;
    }

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, VideoCodecType codecType, Integer surfaceColorFormat, Integer yuvColorFormat, Map<String, String> params, int keyFrameIntervalSec, int forceKeyFrameIntervalMs, BitrateAdjuster bitrateAdjuster, EglBase.Context sharedContext) {
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = codecName;
        this.codecType = codecType;
        this.surfaceColorFormat = surfaceColorFormat;
        this.yuvColorFormat = yuvColorFormat;
        this.yuvFormat = YuvFormat.valueOf(yuvColorFormat, MediaCodecUtils.yuv420spPreferNV21(codecName));
        this.params = params;
        this.keyFrameIntervalSec = keyFrameIntervalSec;
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(forceKeyFrameIntervalMs);
        this.bitrateAdjuster = bitrateAdjuster;
        this.sharedContext = sharedContext;
    }

    @Override
    public VideoCodecStatus attachProxyThread() {
        if (null == this.proxyThreadHandler) {
            Logging.i(TAG, "attach encoder proxyThread");
            try {
                HandlerThread proxyThread = new HandlerThread("proxyThread-Encoder");
                proxyThread.start();
                this.proxyThreadHandler = new Handler(proxyThread.getLooper());
            }
            catch (Exception e) {
                Logging.w(TAG, "attach encoder proxyThread fail!, " + e.getMessage());
            }
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        if (this.running) {
            Logging.w(TAG, "already initialized!");
            return VideoCodecStatus.OK;
        }
        this.callback = callback;
        this.automaticResizeOn = settings.automaticResizeOn;
        this.width = settings.width;
        this.height = settings.height;
        this.alignedWidth = settings.width;
        this.alignedHeight = settings.height;
        this.encodeTimeStamps.clear();
        this.maxFramerate = settings.maxFramerate;
        this.bitrateMode = settings.rateControlMode >= 0 ? settings.rateControlMode : 1;
        this.useSurfaceMode = this.canUseSurface(this.sharedContext) && settings.expectTexture;
        this.shouldUseBaseline = VideoEncoderWrapper.shouldUseBaseline();
        this.shouldFallbackSoftware = false;
        this.shouldResetCodec = false;
        this.deliveredVideoFrame = false;
        if (settings.startBitrate != 0 && settings.maxFramerate != 0) {
            this.bitrateAdjuster.setTargets(settings.startBitrate * 1000, settings.maxFramerate);
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        if (settings.keyFrameInterval != 0 && settings.maxFramerate != 0) {
            this.keyFrameIntervalSec = settings.keyFrameInterval;
        }
        if (Arrays.asList(INTERVAL_HW_EXCEPTION_MODELS).contains(Build.MODEL) && this.keyFrameIntervalSec >= 100) {
            Logging.i(TAG, "Model: " + Build.MODEL + " , need to modify interval. original keyInterval: " + this.keyFrameIntervalSec);
            this.keyFrameIntervalSec = 10;
        }
        if (!this.useSurfaceMode && this.codecType == VideoCodecType.AV1) {
            Logging.i(TAG, "yuv colorFomat, need to modify interval. original keyInterval: " + this.keyFrameIntervalSec);
            this.keyFrameIntervalSec = 2;
        }
        Logging.w(TAG, "initEncode: " + this.width + " x " + this.height + ". @ " + settings.startBitrate + "kbps. Fps: " + settings.maxFramerate + " Use surface mode: " + this.useSurfaceMode + " keyFrameIntervalSec: " + this.keyFrameIntervalSec + " bitrateMode: " + this.bitrateMode);
        return this.initEncodeInternal();
    }

    private VideoCodecStatus initEncodeInternal() {
        VideoCodecStatus status;
        Logging.i(TAG, "initEncodeInternal");
        if (this.outputThread != null) {
            Logging.e(TAG, "initEncodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (null == this.proxyThreadHandler) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        Boolean codecUnavailable = codecUnavailableMap.get(this.codecName);
        if (codecUnavailable != null && codecUnavailable.booleanValue()) {
            Logging.e(TAG, "initEncodeInternal failed, by createByCodecName.");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.lastKeyFrameNs = -1L;
        this.firstEncoderQueueFullMs = -1L;
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                VideoCodecStatus result = VideoCodecStatus.OK;
                HardwareVideoEncoder.this.lock.lock();
                try {
                    HardwareVideoEncoder.this.codec = HardwareVideoEncoder.this.mediaCodecWrapperFactory.createByCodecName(HardwareVideoEncoder.this.codecName);
                }
                catch (Exception e) {
                    Logging.e(HardwareVideoEncoder.TAG, "Cannot create media encoder " + HardwareVideoEncoder.this.codecName);
                    result = VideoCodecStatus.FALLBACK_SOFTWARE;
                }
                finally {
                    HardwareVideoEncoder.this.lock.unlock();
                }
                return result;
            }
        };
        try {
            status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status == null) {
                codecUnavailableMap.put(this.codecName, true);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (status != VideoCodecStatus.OK) {
                codecUnavailableMap.put(this.codecName, true);
                return status;
            }
        }
        catch (Exception e) {
            codecUnavailableMap.put(this.codecName, true);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.getEncoderStyle();
        this.readVideoCapabilities();
        this.parseTimeWaitFromParam();
        this.resolutionAlignmentChecker();
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.alignedHeight * this.alignedWidth > this.maxSupportedHeight * this.maxSupportedWidth || Math.max(this.alignedWidth, this.alignedHeight) > Math.max(this.maxSupportedHeight, this.maxSupportedWidth)) {
                Logging.w(TAG, "initEncode: Not supported size " + this.alignedHeight + "x" + this.alignedWidth);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (this.alignedHeight * this.alignedWidth < this.minSupportedHeight * this.minSupportedWidth || Math.min(this.alignedWidth, this.alignedHeight) < Math.min(this.minSupportedHeight, this.minSupportedWidth)) {
                Logging.w(TAG, "initEncode: Not supported size " + this.alignedHeight + "x" + this.alignedWidth);
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
        }
        int colorFormat = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        int frameRate = this.bitrateAdjustment == 2 ? this.bitrateAdjuster.getCodecConfigFramerate() : this.maxFramerate;
        final MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)this.alignedWidth, (int)this.alignedHeight);
        format.setInteger("bitrate", Math.max(this.adjustedBitrate, this.minSupportedBitrate));
        format.setInteger(KEY_BITRATE_MODE, this.bitrateMode);
        format.setInteger("color-format", colorFormat);
        format.setInteger("frame-rate", frameRate);
        format.setInteger("i-frame-interval", this.keyFrameIntervalSec);
        if (this.codecType == VideoCodecType.H264) {
            this.profileLevelId = this.params.get("profile-level-id");
            String isH264HighProfileSupported = this.params.get("is-highprofile-supported");
            if (this.profileLevelId != null) {
                Logging.i(TAG, "h264_profile:" + this.profileLevelId);
            }
            if (isH264HighProfileSupported != null) {
                Logging.i(TAG, "is-highprofile-supported:" + isH264HighProfileSupported);
            }
            if (this.profileLevelId == null || isH264HighProfileSupported == null || isH264HighProfileSupported.equals("false") || this.shouldUseBaseline) {
                this.profileLevelId = "";
            }
            if ("640c1f".equals(this.profileLevelId)) {
                format.setInteger("profile", 8);
                format.setInteger("level", 512);
            } else if ("4d001f".equals(this.profileLevelId)) {
                format.setInteger("profile", 2);
            } else if ("42e01f".equals(this.profileLevelId)) {
                format.setInteger("profile", 1);
            } else {
                Logging.w(TAG, "Unknown profile level id: " + this.profileLevelId);
            }
        } else if (this.codecType == VideoCodecType.H265) {
            format.setInteger("profile", 1);
            format.setInteger("level", 256);
            format.setInteger(KEY_BITRATE_MODE, this.bitrateMode);
        } else if (this.codecType == VideoCodecType.AV1) {
            format.setInteger("profile", 1);
            format.setInteger("level", 32);
            format.setInteger(KEY_BITRATE_MODE, this.bitrateMode);
        }
        this.customConfigJson = this.params.get("av_enc_video_hwenc_config");
        MediaCodecUtils.applyCustomConfig(format, this.customConfigJson);
        Logging.w(TAG, "Format: " + format);
        final String copyLevelId = this.profileLevelId;
        callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                try {
                    HardwareVideoEncoder.this.codec.configure(format, null, null, 1);
                    if (HardwareVideoEncoder.this.useSurfaceMode) {
                        if (HardwareVideoEncoder.this.sharedContext instanceof EglBase10.Context) {
                            Logging.w(HardwareVideoEncoder.TAG, "Encoders will use EglBase10");
                            HardwareVideoEncoder.this.textureEglBase = new EglBase10((EglBase10.Context)HardwareVideoEncoder.this.sharedContext, EglBase.CONFIG_RECORDABLE);
                        } else {
                            Logging.w(HardwareVideoEncoder.TAG, "Encoders will use EglBase14");
                            HardwareVideoEncoder.this.textureEglBase = new EglBase14((EglBase14.Context)HardwareVideoEncoder.this.sharedContext, EglBase.CONFIG_RECORDABLE);
                        }
                        HardwareVideoEncoder.this.textureInputSurface = HardwareVideoEncoder.this.codec.createInputSurface();
                        HardwareVideoEncoder.this.textureEglBase.createSurface(HardwareVideoEncoder.this.textureInputSurface);
                        HardwareVideoEncoder.this.textureEglBase.makeCurrent();
                    }
                    HardwareVideoEncoder.this.codec.start();
                    Logging.i(HardwareVideoEncoder.TAG, "media encoder started");
                }
                catch (Throwable t) {
                    Logging.e(HardwareVideoEncoder.TAG, "initEncodeInternal failed. " + t.getMessage());
                    HardwareVideoEncoder.this.release();
                    if (t instanceof RuntimeException && !TextUtils.isEmpty((CharSequence)copyLevelId) && MediaCodecUtils.isMediaCodecException((RuntimeException)t) == VideoCodecStatus.ERROR) {
                        return VideoCodecStatus.FALLBACK_DEFAULT_PROFILE;
                    }
                    return VideoCodecStatus.FALLBACK_SOFTWARE;
                }
                return VideoCodecStatus.OK;
            }
        };
        try {
            status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (status != VideoCodecStatus.OK) {
                return status;
            }
        }
        catch (Exception e) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.supportCodecInfo = VideoEncoderUtils.getSupportedEncoders();
        this.running = true;
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        return status;
    }

    private void parseTimeWaitFromParam() {
        boolean parseResult = true;
        try {
            String timeAwaitModeStr = this.params.get(KEY_AV_ENC_VIDEO_ENABLE_DEQUEUE_TIMEWAIT);
            Boolean timeAwaitMode = null;
            if (timeAwaitModeStr != null) {
                timeAwaitMode = Boolean.parseBoolean(timeAwaitModeStr);
            }
            this.forceDequeueTimeWait = timeAwaitMode != null && timeAwaitMode != false;
        }
        catch (Exception e) {
            parseResult = false;
            Logging.i(TAG, "fail to convert timeAwaitMode");
        }
        if (parseResult) {
            Logging.i(TAG, "parse timeWaitFromParam success, value : " + this.forceDequeueTimeWait);
        }
    }

    private boolean parseAlignmentFromParam() {
        try {
            String widthAlignmentStr = this.params.get(KEY_AV_ENC_VIDEO_WIDTH_ALIGNMENT);
            String heightAlignmentStr = this.params.get(KEY_AV_ENC_VIDEO_HEIGHT_ALIGNMENT);
            String forceAlignmentStr = this.params.get(KEY_AV_ENC_VIDEO_FORCE_ALIGNMENT);
            if (widthAlignmentStr != null) {
                this.widthAlignment = Integer.parseInt(widthAlignmentStr);
            }
            if (heightAlignmentStr != null) {
                this.heightAlignment = Integer.parseInt(heightAlignmentStr);
            }
            if (forceAlignmentStr != null) {
                this.forceAlignment = Boolean.parseBoolean(forceAlignmentStr);
            }
            return widthAlignmentStr != null && heightAlignmentStr != null;
        }
        catch (Exception e) {
            Logging.i(TAG, "fail to convert alignment");
            return false;
        }
    }

    private int parseAdjustmentTypeFromParam() {
        try {
            int adjustmentType;
            String paramsAdjustmentType = this.params.get("av_enc_bitrate_adjustment_type");
            if (paramsAdjustmentType != null && (adjustmentType = Integer.parseInt(paramsAdjustmentType)) >= 0 && adjustmentType <= 4) {
                Logging.i(TAG, "parse from param, bitrate adjustment type: " + paramsAdjustmentType);
                return adjustmentType;
            }
        }
        catch (Exception e) {
            Logging.i(TAG, "fail to convert adjustmentType.");
        }
        return -1;
    }

    private boolean parseAdjustmentRebootScheme() {
        try {
            String paramsAdjustmentRebootScheme = this.params.get(KEY_AV_ENC_VIDEO_ADJUSTMENT_RESET);
            if (paramsAdjustmentRebootScheme != null) {
                boolean rebootScheme = Boolean.parseBoolean(paramsAdjustmentRebootScheme);
                Logging.i(TAG, "parse from param, bitrate adjustment rebootScheme: " + rebootScheme);
                return rebootScheme;
            }
        }
        catch (Exception e) {
            Logging.i(TAG, "fail to convert adjustment rebootScheme.");
        }
        return false;
    }

    private void readVideoCapabilities() {
        Range brs;
        Range heights;
        Range widths;
        boolean parseAlignmentFromParam = this.parseAlignmentFromParam();
        if (parseAlignmentFromParam) {
            Logging.w(TAG, "parse from param, align size: " + this.widthAlignment + "x" + this.heightAlignment + " ");
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = null;
        try {
            codecCapabilities = this.codec.getCodecInfo(this.codecType.mimeType());
        }
        catch (Exception e) {
            Logging.e(TAG, "Cannot get CodecInfo " + this.codecName);
        }
        if (codecCapabilities == null) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return;
        }
        if (!parseAlignmentFromParam) {
            this.widthAlignment = Math.max(videoCapabilities.getWidthAlignment(), 16);
            this.heightAlignment = Math.max(videoCapabilities.getHeightAlignment(), 4);
        }
        if ((widths = videoCapabilities.getSupportedWidths()) != null) {
            this.maxSupportedWidth = (Integer)widths.getUpper();
            this.minSupportedWidth = (Integer)widths.getLower();
        }
        if ((heights = videoCapabilities.getSupportedHeights()) != null) {
            this.maxSupportedHeight = (Integer)heights.getUpper();
            this.minSupportedHeight = (Integer)heights.getLower();
        }
        if ((brs = videoCapabilities.getBitrateRange()) != null) {
            this.maxSupportedBitrate = (Integer)brs.getUpper();
            this.minSupportedBitrate = (Integer)brs.getLower();
        }
        Logging.w(TAG, this.codecType.mimeType() + "  max supported size:" + this.maxSupportedWidth + "x" + this.maxSupportedHeight + " min supported size:" + this.minSupportedWidth + "x" + this.minSupportedHeight + " align size: " + this.widthAlignment + "x" + this.heightAlignment + " bitrate range: " + this.maxSupportedBitrate + " -> " + this.minSupportedBitrate);
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.w(TAG, "max supported instance: " + codecCapabilities.getMaxSupportedInstances());
        }
    }

    private void resolutionAlignmentChecker() {
        if (this.useSurfaceMode) {
            if (!this.forceAlignment) {
                return;
            }
            Logging.w(TAG, "force resolution alignment in surface mode");
        }
        this.alignedWidth = (this.width + this.widthAlignment - 1) / this.widthAlignment * this.widthAlignment;
        this.alignedHeight = (this.height + this.heightAlignment - 1) / this.heightAlignment * this.heightAlignment;
        Logging.v(TAG, "resolutionAlignmentChecker, alignedWidth : " + this.alignedWidth + ", alignedHeight: " + this.alignedHeight);
    }

    @Override
    public VideoCodecStatus release() {
        Logging.i(TAG, "release encoder...");
        VideoCodecStatus status = this.releaseInternal();
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        this.inputDropCount = 0;
        this.outputBuilders.clear();
        this.encodeTimeStamps.clear();
        this.codecSpecificInfoMap.clear();
        this.shouldFallbackSoftware = false;
        this.shouldResetCodec = false;
        this.deliveredVideoFrame = false;
        Logging.i(TAG, "release encoder done");
        return status;
    }

    @Override
    public VideoCodecStatus flush() {
        if (this.codec == null || this.callback == null || this.proxyThreadHandler == null) {
            Logging.i(TAG, "[HWS] encode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        Logging.e(TAG, "[HWS] signalEndOfInputStream " + this.codecName + " useSurfaceMode = " + this.useSurfaceMode);
        if (this.useSurfaceMode) {
            VideoCodecStatus videoCodecStatus = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, new Callable<VideoCodecStatus>(){

                @Override
                public VideoCodecStatus call() throws Exception {
                    VideoCodecStatus result = VideoCodecStatus.OK;
                    try {
                        HardwareVideoEncoder.this.codec.signalEndOfInputStream();
                    }
                    catch (Exception e) {
                        Logging.e(HardwareVideoEncoder.TAG, "[HWS] signalEndOfInputStream fail! " + HardwareVideoEncoder.this.codecName);
                        result = VideoCodecStatus.ERROR;
                    }
                    return result;
                }
            });
        } else {
            int inputIndex = -1;
            try {
                Logging.e(TAG, "[HWS] dequeueInputBuffer for flush");
                inputIndex = this.codec.dequeueInputBuffer(0L);
            }
            catch (Exception e) {
                Logging.e(TAG, "[HWS] dequeueInputBuffer failed", e);
                return VideoCodecStatus.ERROR;
            }
            if (inputIndex < 0) {
                Logging.e(TAG, "[HWS] inputIndex < 0");
                return VideoCodecStatus.ERROR;
            }
            try {
                Logging.e(TAG, "[HWS] set end of stream flag");
                this.codec.queueInputBuffer(inputIndex, 0, 0, 0L, 4);
            }
            catch (Exception e) {
                Logging.e(TAG, "[HWS] queueInputBuffer failed", e);
                return VideoCodecStatus.ERROR;
            }
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus resume() {
        if (this.codec == null || this.callback == null || this.proxyThreadHandler == null) {
            Logging.i(TAG, "[HWS] encode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        Logging.e(TAG, "[HWS] Resume " + this.codecName + " useSurfaceMode = " + this.useSurfaceMode);
        if (this.useSurfaceMode) {
            VideoCodecStatus videoCodecStatus = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, new Callable<VideoCodecStatus>(){

                @Override
                public VideoCodecStatus call() throws Exception {
                    VideoCodecStatus result = VideoCodecStatus.OK;
                    try {
                        HardwareVideoEncoder.this.codec.flush();
                    }
                    catch (Exception e) {
                        Logging.e(HardwareVideoEncoder.TAG, "[HWS] flush fail! " + HardwareVideoEncoder.this.codecName);
                        result = VideoCodecStatus.ERROR;
                    }
                    return result;
                }
            });
        } else {
            try {
                this.codec.flush();
            }
            catch (Throwable e) {
                Logging.e(TAG, "[HWS] flush failed", e);
                return VideoCodecStatus.ERROR;
            }
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus detachProxyThread() {
        if (this.proxyThreadHandler != null) {
            this.proxyThreadHandler.removeCallbacksAndMessages(null);
            this.proxyThreadHandler.getLooper().quitSafely();
            this.proxyThreadHandler = null;
            Logging.i(TAG, "detach encoder proxyThread");
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus releaseInternal() {
        Logging.i(TAG, "releaseInternal");
        if (null == this.proxyThreadHandler) {
            return VideoCodecStatus.ERROR;
        }
        if (!this.running) {
            Logging.w(TAG, "release: encoder is not running.");
            return VideoCodecStatus.NO_OUTPUT;
        }
        if (this.outputThread == null) {
            return VideoCodecStatus.NO_OUTPUT;
        }
        this.running = false;
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                HardwareVideoEncoder.this.lock.lock();
                try {
                    Logging.i(HardwareVideoEncoder.TAG, "stop media encoder...");
                    HardwareVideoEncoder.this.codec.stop();
                    Logging.i(HardwareVideoEncoder.TAG, "release media encoder...");
                    HardwareVideoEncoder.this.codec.release();
                }
                catch (Exception e) {
                    Logging.e(HardwareVideoEncoder.TAG, "Media encoder release failed", e);
                    VideoCodecStatus videoCodecStatus = VideoCodecStatus.ERROR;
                    return videoCodecStatus;
                }
                finally {
                    HardwareVideoEncoder.this.textureDrawer.release();
                    HardwareVideoEncoder.this.videoFrameDrawer.release();
                    if (HardwareVideoEncoder.this.textureEglBase != null) {
                        HardwareVideoEncoder.this.textureEglBase.detachCurrent();
                        HardwareVideoEncoder.this.textureEglBase.release();
                        HardwareVideoEncoder.this.textureEglBase = null;
                    }
                    if (HardwareVideoEncoder.this.textureInputSurface != null) {
                        HardwareVideoEncoder.this.textureInputSurface.release();
                        HardwareVideoEncoder.this.textureInputSurface = null;
                    }
                    HardwareVideoEncoder.this.codec = null;
                    HardwareVideoEncoder.this.inputDropCount = 0;
                    HardwareVideoEncoder.this.outputThread = null;
                    HardwareVideoEncoder.this.configBuffer = null;
                    HardwareVideoEncoder.this.outputBuilders.clear();
                    HardwareVideoEncoder.this.encodeTimeStamps.clear();
                    HardwareVideoEncoder.this.codecSpecificInfoMap.clear();
                    HardwareVideoEncoder.this.lock.unlock();
                }
                Logging.i(HardwareVideoEncoder.TAG, "release media encoder done");
                return VideoCodecStatus.OK;
            }
        };
        try {
            VideoCodecStatus status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 5000L, callable);
            if (status != null) {
                return status;
            }
            return VideoCodecStatus.ERROR;
        }
        catch (Exception e) {
            return VideoCodecStatus.ERROR;
        }
    }

    @Override
    public VideoCodecStatus encode(VideoFrame videoFrame, VideoEncoder.EncodeInfo encodeInfo, CodecSpecificInfo codecSpecificInfo) {
        VideoCodecStatus returnValue;
        if (this.codec == null || this.callback == null || this.proxyThreadHandler == null) {
            Logging.i(TAG, "encode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
            return VideoCodecStatus.UNINITIALIZED;
        }
        if (videoFrame.getBuffer() == null) {
            Logging.e(TAG, "encode() - no input data");
            return VideoCodecStatus.ERR_PARAMETER;
        }
        VideoFrame.Buffer videoFrameBuffer = videoFrame.getBuffer();
        boolean isTextureBuffer = videoFrameBuffer instanceof VideoFrame.TextureBuffer;
        EglBase.Context sharedContextInFrame = isTextureBuffer ? ((VideoFrame.TextureBuffer)videoFrameBuffer).getEglBaseContext() : null;
        int frameWidth = videoFrame.getBuffer().getWidth();
        int frameHeight = videoFrame.getBuffer().getHeight();
        boolean shouldUseSurfaceMode = isTextureBuffer && this.canUseSurface(sharedContextInFrame);
        boolean contextChanged = shouldUseSurfaceMode && !HardwareVideoEncoder.objectsEquals(this.sharedContext, sharedContextInFrame);
        boolean newShouldUseBaseline = VideoEncoderWrapper.shouldUseBaseline();
        if (frameWidth != this.width || frameHeight != this.height || shouldUseSurfaceMode != this.useSurfaceMode || contextChanged || this.shouldUseBaseline != newShouldUseBaseline || this.shouldResetCodec) {
            Logging.w(TAG, "[HWS] profile changed new profile : " + frameWidth + " " + frameHeight + " " + shouldUseSurfaceMode + " " + contextChanged + " " + newShouldUseBaseline + " " + this.shouldResetCodec);
            Logging.w(TAG, "[HWS] profile changed old profile : " + this.width + " " + this.height + " " + this.useSurfaceMode + " " + contextChanged + " " + this.shouldUseBaseline + " " + this.shouldResetCodec);
            VideoCodecStatus status = this.resetCodec(frameWidth, frameHeight, shouldUseSurfaceMode, newShouldUseBaseline, sharedContextInFrame);
            if (status != VideoCodecStatus.OK) {
                Logging.w(TAG, "Failed to reset the codec: " + (Object)((Object)status));
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
        }
        if (this.shouldFallbackSoftware) {
            this.release();
            Logging.w(TAG, "Fallback to software encoder");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.inputDropCount > 5) {
            this.release();
            Logging.w(TAG, "Fallback to software, no input buffers available");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (this.outputBuilders.size() > 5 || mockEncoderQueueFull) {
            Logging.e(TAG, "Dropped frame, encoder queue full");
            long now = System.currentTimeMillis();
            if (this.firstEncoderQueueFullMs < 0L) {
                this.firstEncoderQueueFullMs = now;
            }
            if (now - this.firstEncoderQueueFullMs > 2000L) {
                Logging.e(TAG, "Fallback to software, encoder queue full");
                this.release();
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            if (this.callback != null && codecSpecificInfo != null) {
                this.callback.onEncodeBufferPrepared(codecSpecificInfo.opaque);
            }
            return VideoCodecStatus.NO_OUTPUT;
        }
        if (this.forceDequeueTimeWait && this.outputBuilders.size() != 0) {
            this.lock.lock();
            this.condition.signalAll();
            this.lock.unlock();
        }
        this.firstEncoderQueueFullMs = -1L;
        boolean requestedKeyFrame = false;
        for (EncodedImage.FrameType frameType : encodeInfo.frameTypes) {
            if (frameType != EncodedImage.FrameType.VideoFrameKey) continue;
            requestedKeyFrame = true;
            break;
        }
        boolean shouldForceKeyFrame = this.shouldForceKeyFrame(videoFrame.getTimestampNs());
        if (requestedKeyFrame || shouldForceKeyFrame) {
            Logging.i(TAG, "request KeyFrame: " + requestedKeyFrame + ". shouldForce KeyFrame: " + shouldForceKeyFrame);
            this.requestKeyFrame(videoFrame.getTimestampNs());
        }
        int bufferSize = this.alignedWidth * this.alignedHeight * 3 / 2;
        EncodedImage.Builder builder = EncodedImage.builder().setCaptureTimeNs(videoFrame.getTimestampNs()).setCompleteFrame(true).setEncodedWidth(this.width).setEncodedHeight(this.height).setRotation(videoFrame.getRotation());
        this.outputBuilders.offer(builder);
        if (this.callback != null) {
            long opaque = 0L;
            if (null != codecSpecificInfo) {
                opaque = codecSpecificInfo.opaque;
            } else {
                Logging.w(TAG, "onEncodeBufferPrepared fail, cannot get opaque.");
            }
            this.callback.onEncodeBufferPrepared(opaque);
        }
        if ((returnValue = this.useSurfaceMode ? this.encodeTextureBuffer(videoFrame, codecSpecificInfo) : this.encodeByteBuffer(videoFrame, videoFrameBuffer, bufferSize, codecSpecificInfo)) != VideoCodecStatus.OK) {
            this.outputBuilders.pollLast();
        }
        if (this.forceDequeueTimeWait && this.outputBuilders.size() != 0) {
            this.lock.lock();
            this.condition.signalAll();
            this.lock.unlock();
        }
        return returnValue;
    }

    private VideoCodecStatus encodeTextureBuffer(final VideoFrame videoFrame, final CodecSpecificInfo codecSpecificInfo) {
        if (null == this.proxyThreadHandler) {
            return VideoCodecStatus.ERROR;
        }
        if (!this.running) {
            Logging.e(TAG, "encodeTextureBuffer fail, encoder is not initialized!");
            return VideoCodecStatus.ERROR;
        }
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                long presentationTimestampUs = (videoFrame.getTimestampNs() + 500L) / 1000L;
                TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), presentationTimestampUs);
                HardwareVideoEncoder.this.encodeTimeStamps.add(timeStamps);
                try {
                    if (codecSpecificInfo != null) {
                        HardwareVideoEncoder.this.codecSpecificInfoMap.put(presentationTimestampUs, codecSpecificInfo);
                    }
                    GLES20.glClear((int)16384);
                    VideoFrame derotatedFrame = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
                    HardwareVideoEncoder.this.videoFrameDrawer.drawFrame(derotatedFrame, HardwareVideoEncoder.this.textureDrawer, null);
                    HardwareVideoEncoder.this.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
                    VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)videoFrame.getBuffer();
                }
                catch (RuntimeException e) {
                    Logging.e(HardwareVideoEncoder.TAG, "encodeTexture failed", e);
                    HardwareVideoEncoder.this.codecSpecificInfoMap.remove(presentationTimestampUs);
                    HardwareVideoEncoder.this.encodeTimeStamps.remove(timeStamps);
                    return VideoCodecStatus.ERROR;
                }
                return VideoCodecStatus.OK;
            }
        };
        try {
            VideoCodecStatus status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status != null) {
                return status;
            }
            return VideoCodecStatus.ERROR;
        }
        catch (Exception e) {
            return VideoCodecStatus.ERROR;
        }
    }

    private VideoCodecStatus encodeByteBuffer(final VideoFrame videoFrame, final VideoFrame.Buffer videoFrameBuffer, final int bufferSize, final CodecSpecificInfo codecSpecificInfo) {
        if (null == this.proxyThreadHandler) {
            return VideoCodecStatus.ERROR;
        }
        if (!this.running) {
            Logging.e(TAG, "encodeByteBuffer fail, encoder is not initialized!");
            return VideoCodecStatus.ERROR;
        }
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                ByteBuffer buffer;
                int index;
                long presentationTimestampUs = (videoFrame.getTimestampNs() + 500L) / 1000L;
                if (HardwareVideoEncoder.this.lastPresentationTimestampUs == presentationTimestampUs) {
                    presentationTimestampUs = ++HardwareVideoEncoder.this.lastPresentationTimestampUs;
                } else {
                    HardwareVideoEncoder.this.lastPresentationTimestampUs = presentationTimestampUs;
                }
                try {
                    index = HardwareVideoEncoder.this.codec.dequeueInputBuffer(0L);
                }
                catch (IllegalStateException e) {
                    Logging.e(HardwareVideoEncoder.TAG, "dequeueInputBuffer failed", e);
                    if (!HardwareVideoEncoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                if (index == -1) {
                    HardwareVideoEncoder.this.inputDropCount++;
                    Logging.i(HardwareVideoEncoder.TAG, "Dropped frame, no input buffers available");
                    return VideoCodecStatus.NO_OUTPUT;
                }
                HardwareVideoEncoder.this.inputDropCount = 0;
                try {
                    buffer = HardwareVideoEncoder.this.codec.getInputBuffers()[index];
                }
                catch (IllegalStateException e) {
                    Logging.e(HardwareVideoEncoder.TAG, "getInputBuffers failed", e);
                    if (!HardwareVideoEncoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                HardwareVideoEncoder.this.fillInputBuffer(buffer, videoFrameBuffer);
                TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), presentationTimestampUs);
                try {
                    if (codecSpecificInfo != null) {
                        HardwareVideoEncoder.this.codecSpecificInfoMap.put(presentationTimestampUs, codecSpecificInfo);
                    }
                    HardwareVideoEncoder.this.codec.queueInputBuffer(index, 0, bufferSize, presentationTimestampUs, 0);
                    HardwareVideoEncoder.this.encodeTimeStamps.add(timeStamps);
                }
                catch (RuntimeException e) {
                    Logging.e(HardwareVideoEncoder.TAG, "queueInputBuffer failed", e);
                    HardwareVideoEncoder.this.codecSpecificInfoMap.remove(presentationTimestampUs);
                    HardwareVideoEncoder.this.encodeTimeStamps.remove(timeStamps);
                    if (!HardwareVideoEncoder.this.deliveredVideoFrame) {
                        return VideoCodecStatus.FALLBACK_SOFTWARE;
                    }
                    return MediaCodecUtils.isMediaCodecException(e);
                }
                return VideoCodecStatus.OK;
            }
        };
        try {
            VideoCodecStatus status = ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
            if (status != null) {
                return status;
            }
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        catch (Exception e) {
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
    }

    @Override
    public VideoCodecStatus setChannelParameters(short packetLoss, long roundTripTimeMs) {
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setRateAllocation(VideoEncoder.BitrateAllocation bitrateAllocation, int framerate) {
        if (framerate > 60) {
            framerate = 60;
        }
        if (framerate <= 2) {
            framerate = 2;
        }
        int bitrate = bitrateAllocation.getSum();
        if (this.maxFramerate > 0 && this.bitrateAdjustment == 4) {
            if (framerate > this.maxFramerate) {
                bitrate = (int)((float)bitrateAllocation.getSum() * ((float)framerate / (float)this.maxFramerate));
            } else if (framerate < this.maxFramerate) {
                bitrate = (int)((float)bitrateAllocation.getSum() / ((float)framerate / (float)this.maxFramerate));
            }
        }
        Logging.i(TAG, "setRateAllocation, bitrate:" + bitrateAllocation.getSum() + " ,framerate: " + framerate + " ,maxFramerate: " + this.maxFramerate + " adjustBitrate: " + bitrate);
        this.bitrateAdjuster.setTargets(Math.max(bitrate, this.minSupportedBitrate), framerate);
        return VideoCodecStatus.OK;
    }

    @Override
    public boolean isQcomHardware() {
        Logging.w(TAG, "[qualcom hardware] codecName:" + this.codecName);
        return this.codecName.startsWith("OMX.qcom") || this.codecName.startsWith("c2.qti.");
    }

    @Override
    public VideoEncoder.ScalingSettings getScalingSettings() {
        if (this.automaticResizeOn) {
            if (this.codecType == VideoCodecType.VP8) {
                int kLowVp8QpThreshold = 29;
                int kHighVp8QpThreshold = 95;
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (this.codecType == VideoCodecType.H264) {
                int kLowH264QpThreshold = 28;
                int kHighH264QpThreshold = 35;
                return new VideoEncoder.ScalingSettings(28, 35);
            }
            if (this.codecType == VideoCodecType.H265) {
                int kLowH265QpThreshold = 28;
                int kHighH265QpThreshold = 35;
                return new VideoEncoder.ScalingSettings(28, 35);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    @Override
    public String getImplementationName() {
        return "HWEncoder";
    }

    private VideoCodecStatus resetCodec(int newWidth, int newHeight, boolean newUseSurfaceMode, boolean newShouldUseBaseline, EglBase.Context newSharedContext) {
        VideoCodecStatus status = this.releaseInternal();
        if (this.callback != null) {
            this.callback.onEncodeReset();
        }
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        this.width = newWidth;
        this.height = newHeight;
        this.sharedContext = newSharedContext;
        this.useSurfaceMode = newUseSurfaceMode;
        this.shouldUseBaseline = newShouldUseBaseline;
        if (this.sharedContext != null) {
            Logging.w(TAG, "resetCodec. contains shared EglBase.Context. Encoders will use texture mode.");
        } else {
            Logging.w(TAG, "resetCodec. No shared EglBase.Context. Encoders will not use texture mode.");
        }
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long presentationTimestampNs) {
        return this.forcedKeyFrameNs > 0L && presentationTimestampNs > this.lastKeyFrameNs + this.forcedKeyFrameNs;
    }

    private void requestKeyFrame(final long presentationTimestampNs) {
        if (null == this.proxyThreadHandler) {
            return;
        }
        if (!this.running) {
            Logging.e(TAG, "requestKeyFrame fail, encoder is not initialized!");
            return;
        }
        Callable<VideoCodecStatus> callable = new Callable<VideoCodecStatus>(){

            @Override
            public VideoCodecStatus call() throws Exception {
                try {
                    Bundle b = new Bundle();
                    b.putInt("request-sync", 0);
                    HardwareVideoEncoder.this.codec.setParameters(b);
                }
                catch (IllegalStateException e) {
                    Logging.e(HardwareVideoEncoder.TAG, "requestKeyFrame failed", e);
                    return VideoCodecStatus.ERROR;
                }
                HardwareVideoEncoder.this.lastKeyFrameNs = presentationTimestampNs;
                return VideoCodecStatus.OK;
            }
        };
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.proxyThreadHandler, 2000L, callable);
        }
        catch (Exception e) {
            Logging.e(TAG, "requestKeyFrame failed", e);
        }
    }

    private Thread createOutputThread() {
        return new Thread(){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverEncodedImage() {
        if (this.forceDequeueTimeWait) {
            this.lock.lock();
            if (!this.running || this.codec == null) {
                Logging.e(TAG, "[HWS] deliverEncodedImage fail, encoder is not initialized! codec " + this.codecName);
                this.lock.unlock();
                return;
            }
            while (this.running && this.outputBuilders.size() == 0) {
                int timeoWaitMills = 1000 / Math.min(90, Math.max(10, this.maxFramerate));
                try {
                    this.condition.await(timeoWaitMills, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    Logging.e(TAG, "codec = " + this.codecName + " deliverOutput failed " + e);
                }
            }
            this.lock.unlock();
        }
        this.lock.lock();
        if (!this.running || this.codec == null) {
            Logging.e(TAG, "[HWS] deliverEncodedImage fail, encoder is not initialized! codec " + this.codecName);
            this.lock.unlock();
            return;
        }
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int index = this.codec.dequeueOutputBuffer(info, this.forceDequeueTimeWait ? 0L : 100000L);
            if (index < 0) {
                return;
            }
            ByteBuffer codecOutputBuffer = this.codec.getOutputBuffers()[index];
            codecOutputBuffer.position(info.offset);
            codecOutputBuffer.limit(info.offset + info.size);
            if ((info.flags & 2) != 0) {
                Logging.i(TAG, "Config frame generated. Offset: " + info.offset + ". Size: " + info.size);
                this.configBuffer = ByteBuffer.allocateDirect(info.size);
                this.configBuffer.put(codecOutputBuffer);
            } else {
                ByteBuffer frameBuffer;
                boolean isKeyFrame;
                this.bitrateAdjuster.reportEncodedFrame(info.size);
                if (this.adjustedBitrate != this.bitrateAdjuster.getAdjustedBitrateBps()) {
                    this.updateBitrate();
                }
                boolean bl = isKeyFrame = (info.flags & 1) != 0;
                if (isKeyFrame) {
                    Logging.i(TAG, "Sync frame generated");
                }
                if (isKeyFrame && (this.codecType == VideoCodecType.H264 || this.codecType == VideoCodecType.H265)) {
                    Logging.i(TAG, "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + info.offset + ", size " + info.size);
                    frameBuffer = ByteBuffer.allocateDirect(info.size + this.configBuffer.capacity());
                    this.configBuffer.rewind();
                    frameBuffer.put(this.configBuffer);
                    frameBuffer.put(codecOutputBuffer);
                    frameBuffer.flip();
                } else {
                    frameBuffer = codecOutputBuffer.slice();
                }
                EncodedImage.FrameType frameType = isKeyFrame ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta;
                EncodedImage.Builder builder = this.outputBuilders.poll();
                builder.setBuffer(frameBuffer).setFrameType(frameType);
                CodecSpecificInfo codecSpecificInfo = this.codecSpecificInfoMap.remove(info.presentationTimeUs);
                if (codecSpecificInfo == null) {
                    codecSpecificInfo = new CodecSpecificInfo();
                }
                TimeStamps timeStamps = null;
                int encodeDelayFrames = this.encodeTimeStamps.size();
                while (!this.encodeTimeStamps.isEmpty() && (timeStamps = this.encodeTimeStamps.poll()) != null && timeStamps.presentationTimeStampUs != info.presentationTimeUs) {
                    Logging.i(TAG, "HW encodeTimeStamps. cannot find: " + timeStamps.presentationTimeStampUs + "  presentationTimeUs: " + info.presentationTimeUs);
                }
                int encodecDelayTimeMs = -1;
                if (timeStamps == null) {
                    Logging.e(TAG, "HW encodeTimeStamps empty. cannot find: " + info.presentationTimeUs);
                } else {
                    encodecDelayTimeMs = (int)(SystemClock.elapsedRealtime() - timeStamps.encodecStartTimeMs);
                    if (encodecDelayTimeMs > 2000) {
                        Logging.w(TAG, "Very high encode time: " + encodecDelayTimeMs + "ms.");
                        encodecDelayTimeMs = 2000;
                    }
                }
                int supportCodecs = 0;
                if (this.supportCodecInfo != null) {
                    supportCodecs = this.supportCodecInfo.getSupportCodecs();
                }
                if (this.running) {
                    this.callback.onEncodedFrame(builder.createEncodedImage(), encodecDelayTimeMs, encodeDelayFrames, supportCodecs, this.bitrateMode, this.bitrateAdjustment, codecSpecificInfo);
                }
            }
            this.codec.releaseOutputBuffer(index, false);
            this.deliveredVideoFrame = true;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "codec = " + this.codecName + " deliverOutput failed " + e);
            if (!this.deliveredVideoFrame) {
                this.shouldFallbackSoftware = true;
            } else if (MediaCodecUtils.isMediaCodecException(e) != VideoCodecStatus.ERROR) {
                this.shouldFallbackSoftware = true;
            } else {
                this.shouldResetCodec = true;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "codec = " + this.codecName + " deliverOutput error " + e);
            this.shouldFallbackSoftware = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private VideoCodecStatus updateBitrate() {
        if (!this.running) {
            Logging.e(TAG, "update bitrate fail, encoder is not initialized!");
            return VideoCodecStatus.NO_OUTPUT;
        }
        this.adjustedBitrate = this.bitrateAdjuster.getAdjustedBitrateBps();
        try {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", this.adjustedBitrate);
            this.codec.setParameters(params);
            return VideoCodecStatus.OK;
        }
        catch (IllegalStateException e) {
            Logging.e(TAG, "updateBitrate failed", e);
            return MediaCodecUtils.isMediaCodecException(e);
        }
    }

    private boolean canUseSurface(EglBase.Context sharedContext) {
        return sharedContext != null && this.surfaceColorFormat != null;
    }

    protected void fillInputBuffer(ByteBuffer buffer, VideoFrame.Buffer videoFrameBuffer) {
        this.yuvFormat.fillBuffer(buffer, this.alignedWidth, this.alignedHeight, videoFrameBuffer);
    }

    static boolean objectsEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    @Override
    @Nullable
    @SuppressLint(value={"DefaultLocale"})
    public VideoEncoder.EncoderStyle getEncoderStyle() {
        if (this.encoderStyle != null) {
            return this.encoderStyle;
        }
        String cpuName = VideoEncoderWrapper.getCpuName();
        int adjustmentType = this.parseAdjustmentTypeFromParam();
        boolean rebootScheme = this.parseAdjustmentRebootScheme();
        this.encoderStyle = BitrateAdjusterHelper.getEncoderStyle(this.codecName, cpuName, rebootScheme);
        if (adjustmentType >= 0) {
            this.encoderStyle.bitrateAdjustment = adjustmentType;
        }
        Logging.i(TAG, "encoderStyle: " + this.encoderStyle + " cpuName: " + cpuName);
        if (this.bitrateAdjuster instanceof FactorBitrateAdjuster) {
            FactorBitrateAdjuster cfr_ignored_0 = (FactorBitrateAdjuster)this.bitrateAdjuster;
            this.encoderStyle.bitrateAdjustNumerator = 950;
            FactorBitrateAdjuster cfr_ignored_1 = (FactorBitrateAdjuster)this.bitrateAdjuster;
            this.encoderStyle.bitrateAdjustDenominator = 1000;
        }
        this.bitrateAdjustment = this.encoderStyle.bitrateAdjustment;
        return this.encoderStyle;
    }

    @Override
    public long getResetCoolDownTimeMs() {
        return 10000L;
    }

    @Override
    public boolean isHardwareEncoder() {
        return true;
    }

    @Override
    @Nullable
    public VideoEncoder.VideoHWCodecSpec getVideoHWCodecSpec() {
        Logging.i(TAG, "getVideoHWCodecSpec: " + this.encoderStyle);
        int profile = 0;
        String supportCodecNames = "";
        if (this.supportCodecInfo != null) {
            supportCodecNames = this.supportCodecInfo.getCodecNames();
        }
        if (this.profileLevelId == null) {
            return new VideoEncoder.VideoHWCodecSpec(this.codecName, this.maxSupportedWidth + "x" + this.maxSupportedHeight, this.bitrateMode, this.useSurfaceMode ? 1 : 0, profile, this.minSupportedBitrate, supportCodecNames);
        }
        if ("640c1f".equals(this.profileLevelId)) {
            profile = 3;
        } else if ("4d001f".equals(this.profileLevelId)) {
            profile = 2;
        } else if ("42e01f".equals(this.profileLevelId)) {
            profile = 1;
        }
        return new VideoEncoder.VideoHWCodecSpec(this.codecName, this.maxSupportedWidth + "x" + this.maxSupportedHeight, this.bitrateMode, this.useSurfaceMode ? 0 : 1, profile, this.minSupportedBitrate, supportCodecNames);
    }

    @Override
    public long createNativeVideoEncoder() {
        return 0L;
    }

    private static enum YuvFormat {
        I420{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer) {
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                int dstChromaWidth = (destWidth + 1) / 2;
                int dstChromaHeight = (destHeight + 1) / 2;
                int minSize = destWidth * destHeight + dstChromaWidth * dstChromaHeight * 2;
                if (dstBuffer.capacity() < minSize) {
                    throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dstBuffer.capacity());
                }
                boolean startY = false;
                int startU = destHeight * destWidth;
                int startV = startU + dstChromaHeight * dstChromaWidth;
                dstBuffer.position(0);
                ByteBuffer dstY = dstBuffer.slice();
                dstBuffer.position(startU);
                ByteBuffer dstU = dstBuffer.slice();
                dstBuffer.position(startV);
                ByteBuffer dstV = dstBuffer.slice();
                YuvHelper.I420Copy(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstY, destWidth, dstU, dstChromaWidth, dstV, dstChromaWidth, i420.getWidth(), i420.getHeight());
                i420.release();
            }
        }
        ,
        NV12{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer) {
                2.fillNV12Buffer(dstBuffer, destWidth, destHeight, srcBuffer, false);
            }
        }
        ,
        NV21{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer) {
                3.fillNV12Buffer(dstBuffer, destWidth, destHeight, srcBuffer, true);
            }
        };


        abstract void fillBuffer(ByteBuffer var1, int var2, int var3, VideoFrame.Buffer var4);

        static void fillNV12Buffer(ByteBuffer dstBuffer, int destWidth, int destHeight, VideoFrame.Buffer srcBuffer, boolean revertUV) {
            VideoFrame.I420Buffer i420 = srcBuffer.toI420();
            int dstChromaWidth = (destWidth + 1) / 2;
            int dstChromaHeight = (destHeight + 1) / 2;
            int minSize = destWidth * destHeight + dstChromaWidth * dstChromaHeight * 2;
            if (dstBuffer.capacity() < minSize) {
                throw new IllegalArgumentException("Expected destination buffer capacity to be at least " + minSize + " was " + dstBuffer.capacity());
            }
            boolean startY = false;
            int startUV = destHeight * destWidth;
            dstBuffer.position(0);
            ByteBuffer dstY = dstBuffer.slice();
            dstBuffer.position(startUV);
            ByteBuffer dstUV = dstBuffer.slice();
            ByteBuffer tmpDataU = revertUV ? i420.getDataV() : i420.getDataU();
            int tmpStrideU = revertUV ? i420.getStrideV() : i420.getStrideU();
            ByteBuffer tmpDataV = revertUV ? i420.getDataU() : i420.getDataV();
            int tmpStrideV = revertUV ? i420.getStrideU() : i420.getStrideV();
            YuvHelper.I420ToNV12(i420.getDataY(), i420.getStrideY(), tmpDataU, tmpStrideU, tmpDataV, tmpStrideV, dstY, destWidth, dstUV, dstChromaWidth * 2, i420.getWidth(), i420.getHeight());
            i420.release();
        }

        static YuvFormat valueOf(int colorFormat, boolean yuv420spPreferNV21) {
            switch (colorFormat) {
                case 19: {
                    return I420;
                }
                case 21: 
                case 2141391872: 
                case 2141391876: {
                    return yuv420spPreferNV21 ? NV21 : NV12;
                }
            }
            throw new IllegalArgumentException("Unsupported colorFormat: " + colorFormat);
        }
    }

    private static class TimeStamps {
        private final long encodecStartTimeMs;
        private final long presentationTimeStampUs;

        public TimeStamps(long encodecStartTimeMs, long presentationTimeStampUs) {
            this.encodecStartTimeMs = encodecStartTimeMs;
            this.presentationTimeStampUs = presentationTimeStampUs;
        }
    }
}

