/*
 * Decompiled with CFR 0.152.
 */
package io.agora.mediaplayer;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ContentFileReader {
    private static final String TAG = "ContentFileReader";
    private FileInputStream fileInputStream = null;
    private FileChannel fileChannel = null;
    private ParcelFileDescriptor pfd = null;

    @CalledByNative
    public ContentFileReader() {
        Logging.v(TAG, "constructor");
    }

    @CalledByNative
    public int open(String url) {
        Uri uri = Uri.parse((String)url);
        if (this.fileInputStream != null) {
            Logging.e(TAG, "has opened file ");
            return -2;
        }
        int ret = 0;
        Context context = ContextUtils.getApplicationContext();
        try {
            this.pfd = context.getContentResolver().openFileDescriptor(uri, "r");
            this.fileInputStream = new FileInputStream(this.pfd.getFileDescriptor());
            this.fileChannel = this.fileInputStream.getChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.e(TAG, "open error:" + e.getMessage());
            ret = -3;
            this.closeFile();
        }
        return ret;
    }

    @CalledByNative
    public long getFileSize() {
        if (this.fileChannel != null) {
            try {
                return this.fileChannel.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                Logging.e(TAG, "getFileSize error:" + e.getMessage());
            }
        }
        return -2L;
    }

    @CalledByNative
    public long seek(long pos) {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.position(pos);
                return pos;
            }
            catch (Exception e) {
                e.printStackTrace();
                Logging.e(TAG, "seek error: " + e.getMessage());
            }
        }
        return -2L;
    }

    @CalledByNative
    public void closeFile() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logging.e(TAG, "closeFile Step1 error: " + e.getMessage());
            }
            this.fileChannel = null;
        }
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logging.e(TAG, "ContentFileReader closeFile Step2 error: " + e.getMessage());
            }
            this.fileInputStream = null;
        }
        if (this.pfd != null) {
            try {
                this.pfd.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                Logging.e(TAG, "ContentFileReader closeFile Step3 error: " + e.getMessage());
            }
            this.pfd = null;
        }
    }

    @CalledByNative
    public int read(ByteBuffer readByteBuffer) {
        if (this.fileChannel == null) {
            return -2;
        }
        readByteBuffer.clear();
        try {
            return this.fileChannel.read(readByteBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logging.e(TAG, "ContentFileReader read error: " + e.getMessage());
            return -2;
        }
    }

    @CalledByNative
    public long getCurrentPosition() {
        if (this.fileChannel == null) {
            return -2L;
        }
        try {
            return this.fileChannel.position();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logging.e(TAG, "AssetsFileReader read error: " + e.getMessage());
            return -2L;
        }
    }
}

