/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.VisibleForTesting;
import io.agora.rtc2.internal.AudioRoutingController;
import io.agora.utils2.internal.Logging;

public class AudioDeviceInventoryMocker
implements AudioRoutingController.AudioDeviceInventory {
    private static final String TAG = "AudioRoute";
    private final int STATE_DISCONNECT = -1;
    private final int STATE_CONNECT = 1;
    private final String HEADSET_EXTRA_STATE = "state";
    private HeadsetBroadcastReceiver mHeadsetReceiver = null;
    private BTHeadsetBroadcastReceiver mBTHeadsetReceiver = null;
    private AudioRoutingController.AudioDeviceChangedCallback mAudioDeviceChangedCb;
    private int mHeadsetType = -1;
    private static AudioRoutingController.MockedBroadcaseter mockedBroadcaster = null;

    @VisibleForTesting
    public static void setMockedBroadcaster(AudioRoutingController.MockedBroadcaseter mockedBroadcaster) {
        AudioDeviceInventoryMocker.mockedBroadcaster = mockedBroadcaster;
    }

    public AudioDeviceInventoryMocker() {
        Logging.i(TAG, "AudioDeviceInventoryMocker ctor!");
    }

    @Override
    public void initialize() {
        Logging.i(TAG, "AudioDeviceInventoryMocker initialize +");
        this.initHeadsetBroadcastReceiver();
        this.initBtBroadcastReceiver();
    }

    @Override
    public void dispose() {
        if (this.mHeadsetReceiver != null && this.mHeadsetReceiver.getRegistered()) {
            if (mockedBroadcaster != null) {
                mockedBroadcaster.unRegisterReceiver(this.mHeadsetReceiver);
            }
            this.mHeadsetReceiver.setRegistered(false);
        }
        if (this.mBTHeadsetReceiver != null && this.mBTHeadsetReceiver.getRegistered()) {
            if (mockedBroadcaster != null) {
                mockedBroadcaster.unRegisterReceiver(this.mBTHeadsetReceiver);
            }
            this.mBTHeadsetReceiver.setRegistered(false);
        }
        this.mHeadsetReceiver = null;
        this.mBTHeadsetReceiver = null;
    }

    @Override
    public boolean isDeviceAvaliable(int route) {
        boolean avaliable = false;
        if (route != 5 && (route == 0 || route == 2)) {
            avaliable = this.mHeadsetType == route;
        }
        return avaliable;
    }

    @Override
    public void setAudioDeviceChangeCallback(AudioRoutingController.AudioDeviceChangedCallback cb) {
        this.mAudioDeviceChangedCb = cb;
    }

    private void initHeadsetBroadcastReceiver() {
        if (this.mHeadsetReceiver == null) {
            this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
        }
        if (!this.mHeadsetReceiver.getRegistered()) {
            IntentFilter hs = new IntentFilter("android.intent.action.HEADSET_PLUG");
            if (mockedBroadcaster != null) {
                mockedBroadcaster.registerReceiver(this.mHeadsetReceiver, hs);
            }
            this.mHeadsetReceiver.setRegistered(true);
        }
    }

    private void initBtBroadcastReceiver() {
        if (this.mBTHeadsetReceiver == null) {
            this.mBTHeadsetReceiver = new BTHeadsetBroadcastReceiver();
        }
        IntentFilter bt = new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bt.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        if (!this.mBTHeadsetReceiver.getRegistered()) {
            if (mockedBroadcaster != null) {
                mockedBroadcaster.registerReceiver(this.mBTHeadsetReceiver, bt);
            }
            this.mBTHeadsetReceiver.setRegistered(true);
        }
    }

    private void onAudioDeviceChanged(int route, boolean connect) {
        if (this.mAudioDeviceChangedCb != null) {
            this.mAudioDeviceChangedCb.onAudioDeviceChanged(connect, route);
        }
    }

    private void processBluetoothIntent(Intent intent) {
        String action = intent.getAction();
        try {
            if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                int previousState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String deviceName = device != null ? device.getName() : "null name";
                switch (state) {
                    case 2: {
                        this.onAudioDeviceChanged(5, true);
                        break;
                    }
                    case 0: {
                        this.onAudioDeviceChanged(5, false);
                        break;
                    }
                }
                Logging.d(TAG, "BT " + deviceName + " hfp connect state : " + previousState + ", " + state);
            } else if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -99);
                int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -99);
                switch (state) {
                    case 10: {
                        this.onAudioDeviceChanged(5, false);
                        break;
                    }
                }
                Logging.d(TAG, "BluetoothAdapter.ACTION_STATE_CHANGED prev " + previousState + ", " + state);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "BT broadcast receiver onReceive fail ", e);
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private HeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equalsIgnoreCase("android.intent.action.HEADSET_PLUG") || !intent.hasExtra("state")) {
                return;
            }
            int plugged = intent.getIntExtra("state", -1);
            int microphone = intent.getIntExtra("microphone", -1);
            if (plugged == 1) {
                AudioDeviceInventoryMocker.this.mHeadsetType = microphone == 1 ? 0 : 2;
            }
            boolean connect = plugged == 1;
            AudioDeviceInventoryMocker.this.onAudioDeviceChanged(AudioDeviceInventoryMocker.this.mHeadsetType, connect);
        }
    }

    private class BTHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private boolean isRegistered = false;

        private BTHeadsetBroadcastReceiver() {
        }

        public boolean getRegistered() {
            return this.isRegistered;
        }

        public void setRegistered(boolean isReg) {
            this.isRegistered = isReg;
        }

        public void onReceive(Context context, Intent intent) {
            AudioDeviceInventoryMocker.this.processBluetoothIntent(intent);
        }
    }
}

