/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.agora.base.VideoFrame;
import io.agora.base.internal.CalledByNative;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.SurfaceEglRenderer;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.GlRectDrawer;
import io.agora.base.internal.video.HdrUtil;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.VideoSink;
import java.lang.ref.WeakReference;
import java.util.Random;

public abstract class SurfaceEglRendererHelper
implements VideoSink,
RendererCommon.RendererEvents,
View.OnLayoutChangeListener {
    private static final String TAG = "SurfaceEglRendererHelper";
    protected long nativeVideoRendererAndroid;
    protected final Object nativeLock = new Object();
    @NonNull
    protected final WeakReference<View> view;
    protected final Object eglRenderLock = new Object();
    protected final String resourceName;
    @NonNull
    protected SurfaceEglRenderer eglRenderer = null;
    protected static final int TRANSFER_INVAILD = -1;
    protected RenderConfig renderConfig = new RenderConfig();
    protected volatile boolean isInitialized = false;
    protected volatile boolean disposed;
    private final Handler handler;
    private EglBase.Context sharedContext;
    private int viewWidth;
    private int viewHeight;
    private int transfer = -1;
    private boolean mIs10bitLumaBitDepth = false;
    private long vsyncDurationNs = 0L;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final int DEFAULT_DISPLAY_REFRESH_RATE = 60;
    @Nullable
    private DefaultDisplayListener displayListener = null;

    @CalledByNative
    public static SurfaceEglRendererHelper newInstance(long nativeRendererHelper, Object view) {
        if (view instanceof SurfaceView) {
            return new SurfaceViewEglRenderHelper(nativeRendererHelper, (SurfaceView)view);
        }
        if (view instanceof TextureView) {
            return new TextureViewEglRenderHelper(nativeRendererHelper, (TextureView)view);
        }
        if (view instanceof SurfaceTexture) {
            return new SurfaceTextureEglRenderHelper(nativeRendererHelper, (SurfaceTexture)view);
        }
        return null;
    }

    public SurfaceEglRendererHelper(long nativeRendererHelper, @NonNull View renderView) {
        this.nativeVideoRendererAndroid = nativeRendererHelper;
        this.view = new WeakReference<View>(renderView);
        this.resourceName = this.getResourceName(renderView);
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.handler = new Handler(Looper.getMainLooper());
        this.disposed = false;
        this.viewWidth = renderView.getWidth();
        this.viewHeight = renderView.getHeight();
        renderView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        this.registerDisplayListener();
    }

    public SurfaceEglRendererHelper(long nativeRendererHelper, @NonNull SurfaceTexture renderView) {
        this.nativeVideoRendererAndroid = nativeRendererHelper;
        this.resourceName = this.toString();
        this.view = new WeakReference<Object>(null);
        this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
        this.handler = new Handler(Looper.getMainLooper());
        this.disposed = false;
    }

    protected boolean initImpl(EglBase.Context sharedContext, RenderConfig renderConfig) {
        this.sharedContext = sharedContext;
        this.renderConfig.setMirror(renderConfig.isMirror());
        this.renderConfig.enableAlphaMask(renderConfig.isEnableAlphaMask());
        this.logI("init() [mirror: " + renderConfig.isMirror() + ", renderMode: " + renderConfig.getRenderMode() + "] , transfer: " + this.transfer + "]");
        this.eglRenderer.enableAlphaMask(renderConfig.isEnableAlphaMask());
        this.eglRenderer.init(sharedContext, this, this.transfer, new GlRectDrawer(), renderConfig.isUseVsync());
        this.eglRenderer.setMirror(renderConfig.isMirror());
        if (renderConfig.getRect() != null) {
            this.eglRenderer.updateCropArea(renderConfig.getRect());
        }
        this.setRenderMode(renderConfig.getRenderMode());
        this.postOrRun(new Runnable(){

            @Override
            public void run() {
                Logging.i(SurfaceEglRendererHelper.TAG, "run check Surface.");
                SurfaceEglRendererHelper.this.checkAndSetExistSurface();
            }
        });
        this.isInitialized = true;
        return true;
    }

    @CalledByNative
    public final boolean init(EglBase.Context sharedContext, boolean mirror, int renderMode, boolean useVsync, boolean enableAlphaMask) {
        try {
            this.renderConfig.setRenderMode(renderMode);
            this.renderConfig.setMirror(mirror);
            this.renderConfig.setUseVsync(useVsync);
            this.renderConfig.enableAlphaMask(enableAlphaMask);
            this.transfer = 0;
            this.mIs10bitLumaBitDepth = false;
            return this.initImpl(sharedContext, this.renderConfig);
        }
        catch (Throwable e) {
            Logging.w(TAG, " Failed to init eglRender", e);
            return false;
        }
    }

    @CalledByNative
    public final boolean isInitialized() {
        return this.isInitialized;
    }

    protected abstract void reInit(EglBase.Context var1);

    protected abstract void checkAndSetExistSurface();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        View view = (View)this.view.get();
        if (v != view) {
            return;
        }
        int viewWidth = v.getWidth();
        int viewHeight = v.getHeight();
        if (this.viewWidth != viewWidth || this.viewHeight != viewHeight) {
            this.logI("onLayoutChange()");
            this.viewWidth = viewWidth;
            this.viewHeight = viewHeight;
            this.updateRenderSettings();
            Object object = this.nativeLock;
            synchronized (object) {
                if (this.nativeVideoRendererAndroid != 0L) {
                    this.nativeNotifyRequestLastFrame(this.nativeVideoRendererAndroid);
                }
            }
        }
    }

    @CalledByNative
    public void dispose() {
        View view = (View)this.view.get();
        if (view != null) {
            this.logI("removeOnLayoutChangeListener()");
            view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        }
        this.unregisterDisplayListener();
        this.isInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void destroyNativeInstance() {
        Object object = this.nativeLock;
        synchronized (object) {
            this.nativeVideoRendererAndroid = 0L;
        }
    }

    @CalledByNative
    public void setMirror(boolean mirror) {
        this.logI("setMirror() [mirror: " + mirror + "]");
        if (this.disposed) {
            return;
        }
        this.renderConfig.setMirror(mirror);
        this.eglRenderer.setMirror(mirror);
    }

    @CalledByNative
    public void updateCropArea(int left, int top, int right, int bottom) {
        Rect rect = new Rect(left, top, right, bottom);
        this.logI("updateCropArea() [rect: " + rect.toString() + "]");
        if (this.disposed) {
            return;
        }
        this.renderConfig.setRect(rect);
        this.eglRenderer.updateCropArea(rect);
    }

    @CalledByNative
    public void setBackgroundColor(int color) {
        this.logI("setBackgroudColor() [colr: " + color + "]");
        if (this.disposed) {
            return;
        }
        this.eglRenderer.setBackgroundColor(color);
    }

    @CalledByNative
    public void setRenderMode(int renderMode) {
        this.logI("setRenderMode() [renderMode: " + renderMode + "]");
        if (this.disposed) {
            return;
        }
        this.renderConfig.setRenderMode(renderMode);
        this.updateRenderSettings();
    }

    @CalledByNative
    public void resetFirstFrameFlag() {
        this.logI("resetFirstFrameFlag");
        if (this.disposed) {
            return;
        }
        this.eglRenderer.resetFirstFrameFlag();
    }

    @CalledByNative
    public int getFrameDrawn() {
        return this.eglRenderer.getFrameDrawn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CalledByNative
    public void onFrame(VideoFrame frame) {
        boolean shouldResetDepth;
        if (this.disposed) {
            return;
        }
        int transferId = 0;
        if (null != frame.getColorSpace() && null != frame.getColorSpace().getTransfer()) {
            transferId = frame.getColorSpace().getTransfer().getTransfer();
        }
        VideoFrame.Buffer videoFrameBuffer = frame.getBuffer();
        boolean isTextureBuffer = videoFrameBuffer instanceof VideoFrame.TextureBuffer;
        boolean is10bitLumaBitDepth = HdrUtil.is10BitLumaDepth(transferId);
        boolean bl = shouldResetDepth = is10bitLumaBitDepth != this.mIs10bitLumaBitDepth || this.eglRenderer.getSdrTransformHdr() != HdrUtil.nativeHdrSdrTransform();
        if (isTextureBuffer) {
            EglBase.Context sharedContextInFrame = ((VideoFrame.TextureBuffer)videoFrameBuffer).getEglBaseContext();
            if (!SurfaceEglRendererHelper.objectsEquals(this.sharedContext, sharedContextInFrame) || shouldResetDepth) {
                if (shouldResetDepth) {
                    this.transfer = transferId;
                    this.mIs10bitLumaBitDepth = is10bitLumaBitDepth;
                    this.logI("onFrame() texture, reInit transfer: " + this.transfer + " buffer transfer: " + transferId + " sdrTransformHdr: " + HdrUtil.nativeHdrSdrTransform());
                }
                this.reInit(sharedContextInFrame);
            }
        } else if (shouldResetDepth) {
            this.transfer = transferId;
            this.mIs10bitLumaBitDepth = is10bitLumaBitDepth;
            this.logI("onFrame() yuv, reInit transfer: " + this.transfer + " buffer transfer: " + transferId + " sdrTransformHdr: " + HdrUtil.nativeHdrSdrTransform());
            this.reInit(this.sharedContext);
        }
        Object object = this.eglRenderLock;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            this.eglRenderer.onFrame(frame);
        }
        if (this.transfer == -1) {
            this.transfer = transferId;
        }
    }

    private String getResourceName(View view) {
        try {
            return view.getContext().getResources().getResourceEntryName(view.getId());
        }
        catch (Exception e) {
            return "" + Math.abs(new Random().nextInt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFirstFrameRendered(int videoWidth, int videoHeight, int rotation) {
        this.logI("onFirstFrameRendered videoWidth:" + videoWidth + " videoHeight:" + videoHeight + " rotation:" + rotation);
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeVideoRendererAndroid != 0L) {
                this.nativeNotifyFirstVideoFrame(this.nativeVideoRendererAndroid, videoWidth, videoHeight, rotation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrameDrawn(long timestamps, long renderCostTime) {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeVideoRendererAndroid != 0L) {
                this.nativeNofityFrameDrawn(this.nativeVideoRendererAndroid, timestamps, renderCostTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrameDropped() {
        Object object = this.nativeLock;
        synchronized (object) {
            if (this.nativeVideoRendererAndroid != 0L) {
                this.nativeNofityFrameDropped(this.nativeVideoRendererAndroid);
            }
        }
    }

    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
    }

    private int getViewWidth() {
        View view = (View)this.view.get();
        if (view != null && this.viewWidth == 0) {
            this.viewWidth = view.getWidth();
        }
        return this.viewWidth;
    }

    private int getViewHeight() {
        View view = (View)this.view.get();
        if (view != null && this.viewHeight == 0) {
            this.viewHeight = view.getHeight();
        }
        return this.viewHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRenderSettings() {
        this.logI("updateRenderSettings()");
        Object object = this.eglRenderLock;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            int viewWidth = this.getViewWidth();
            int viewHeight = this.getViewHeight();
            this.logI("updateRenderSettings. Layout size: " + viewWidth + "x" + viewHeight);
            this.eglRenderer.setViewSize(viewWidth, viewHeight);
            this.eglRenderer.setRenderMode(this.renderConfig.getRenderMode());
        }
    }

    private void registerDisplayListener() {
        this.logI("registerDisplayListener");
        WindowManager windowManager = null;
        if (ContextUtils.getApplicationContext() != null) {
            windowManager = (WindowManager)ContextUtils.getApplicationContext().getSystemService("window");
        }
        this.displayListener = windowManager != null && ContextUtils.getApplicationContext() != null ? (Build.VERSION.SDK_INT >= 17 ? this.maybeBuildDefaultDisplayListenerV17(ContextUtils.getApplicationContext()) : null) : null;
        if (this.displayListener != null && Build.VERSION.SDK_INT >= 17) {
            this.displayListener.register();
        }
    }

    private void unregisterDisplayListener() {
        if (this.displayListener != null && Build.VERSION.SDK_INT >= 17) {
            this.logI("unregisterDisplayListener()");
            this.displayListener.unregister();
        }
    }

    @RequiresApi(value=17)
    private DefaultDisplayListener maybeBuildDefaultDisplayListenerV17(Context context) {
        if (ContextUtils.getApplicationContext() == null) {
            return null;
        }
        DisplayManager manager = (DisplayManager)ContextUtils.getApplicationContext().getSystemService("display");
        return manager == null ? null : new DefaultDisplayListener(manager);
    }

    private void updateDefaultDisplayRefreshRateParams() {
        if (ContextUtils.getApplicationContext() == null) {
            this.vsyncDurationNs = 0L;
            return;
        }
        WindowManager windowManager = (WindowManager)ContextUtils.getApplicationContext().getSystemService("window");
        if (windowManager != null) {
            Display defaultDisplay = windowManager.getDefaultDisplay();
            if (defaultDisplay != null) {
                double defaultDisplayRefreshRate = defaultDisplay.getRefreshRate();
                if (defaultDisplayRefreshRate == 0.0) {
                    defaultDisplayRefreshRate = 60.0;
                }
                this.vsyncDurationNs = (long)(1.0E9 / defaultDisplayRefreshRate);
            } else {
                this.logI("Unable to query display refresh rate, set to default 60 fps");
                this.vsyncDurationNs = 16666666L;
            }
            if (this.eglRenderer != null) {
                this.eglRenderer.updateVsyncDuration(this.vsyncDurationNs);
            }
        }
    }

    private void postOrRun(Runnable r) {
        if (Thread.currentThread() == this.handler.getLooper().getThread()) {
            r.run();
        } else {
            this.handler.post(r);
        }
    }

    protected void logD(String string) {
        Logging.d(TAG, this.resourceName + ": " + string);
    }

    protected void logI(String string) {
        Logging.i(TAG, this.resourceName + ": " + string);
    }

    protected void logE(String string) {
        Logging.e(TAG, this.resourceName + ": " + string);
    }

    private static boolean objectsEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected native void nativeNotifyRequestLastFrame(long var1);

    protected native void nativeNotifySurfaceSizeChanged(long var1, int var3, int var4);

    protected native void nativeNotifyFirstVideoFrame(long var1, int var3, int var4, int var5);

    protected native void nativeNofityFrameDrawn(long var1, long var3, long var5);

    protected native void nativeNofityFrameDropped(long var1);

    @RequiresApi(value=17)
    private final class DefaultDisplayListener
    implements DisplayManager.DisplayListener {
        private final DisplayManager displayManager;

        public DefaultDisplayListener(DisplayManager displayManager) {
            this.displayManager = displayManager;
        }

        public void register() {
            this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, SurfaceEglRendererHelper.this.handler);
        }

        public void unregister() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                SurfaceEglRendererHelper.this.updateDefaultDisplayRefreshRateParams();
            }
        }
    }

    private class RenderConfig {
        private volatile boolean mirror;
        private volatile int renderMode;
        private volatile boolean useVsync;
        private volatile boolean enableAlphaMask;
        private volatile Rect rect;

        public RenderConfig() {
            this.mirror = true;
            this.renderMode = 2;
            this.useVsync = false;
            this.enableAlphaMask = false;
        }

        public RenderConfig(boolean mirror, int renderMode, boolean useVsync) {
            this.mirror = mirror;
            this.renderMode = renderMode;
            this.useVsync = useVsync;
        }

        public RenderConfig(boolean mirror, int renderMode, boolean useVsync, Rect rect) {
            this.mirror = mirror;
            this.renderMode = renderMode;
            this.useVsync = useVsync;
            this.rect = rect;
        }

        public boolean isMirror() {
            return this.mirror;
        }

        public void setMirror(boolean mirror) {
            this.mirror = mirror;
        }

        public int getRenderMode() {
            return this.renderMode;
        }

        public void setRenderMode(int renderMode) {
            this.renderMode = renderMode;
        }

        public boolean isUseVsync() {
            return this.useVsync;
        }

        public void setUseVsync(boolean useVsync) {
            this.useVsync = useVsync;
        }

        public Rect getRect() {
            return this.rect;
        }

        public void setRect(Rect rect) {
            this.rect = rect;
        }

        public boolean isEnableAlphaMask() {
            return this.enableAlphaMask;
        }

        public void enableAlphaMask(boolean enable) {
            this.enableAlphaMask = enable;
        }
    }

    private static class SurfaceTextureEglRenderHelper
    extends SurfaceEglRendererHelper {
        @NonNull
        private final SurfaceTexture renderSurfaceTexture;
        private int surfaceTextureWidth = -1;
        private int surfaceTextureHeight = -1;

        SurfaceTextureEglRenderHelper(long nativeVideoRendererAndroid, @NonNull SurfaceTexture surfaceTexture) {
            super(nativeVideoRendererAndroid, surfaceTexture);
            this.logI("SurfaceTextureEglRenderHelper constructor");
            this.renderSurfaceTexture = surfaceTexture;
        }

        @Override
        protected boolean initImpl(EglBase.Context sharedContext, RenderConfig renderConfig) {
            this.logI("SurfaceTextureEglRenderHelper initImpl");
            if (!super.initImpl(sharedContext, renderConfig)) {
                return false;
            }
            this.eglRenderer.createEglSurface(this.renderSurfaceTexture);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reInit(EglBase.Context sharedContext) {
            this.logI("SurfaceTextureEglRenderHelper reInit");
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    return;
                }
                this.eglRenderer.release();
                this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
                this.eglRenderer.isRenderOnSurfaceView(false);
                this.initImpl(sharedContext, this.renderConfig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            this.logI("dispose()");
            if (this.eglRenderer == null) {
                return;
            }
            super.dispose();
            if (this.disposed) {
                return;
            }
            Object object = this.eglRenderLock;
            synchronized (object) {
                this.disposed = true;
                this.eglRenderer.release();
            }
            object = this.nativeLock;
            synchronized (object) {
                this.nativeVideoRendererAndroid = 0L;
            }
        }

        @Override
        public void onFrame(VideoFrame frame) {
            if (this.disposed || frame == null || frame.getBuffer() == null) {
                this.logI("SurfaceTextureEglRenderHelper onFrame(), disposed" + this.disposed);
                if (frame == null || frame.getBuffer() == null) {
                    this.logI("null frame");
                }
                return;
            }
            if (this.surfaceTextureWidth != frame.getBuffer().getWidth() || this.surfaceTextureHeight != frame.getBuffer().getHeight()) {
                this.surfaceTextureWidth = frame.getBuffer().getWidth();
                this.surfaceTextureHeight = frame.getBuffer().getHeight();
                if (this.renderSurfaceTexture != null && this.surfaceTextureWidth > 0 && this.surfaceTextureHeight > 0) {
                    this.renderSurfaceTexture.setDefaultBufferSize(this.surfaceTextureWidth, this.surfaceTextureHeight);
                }
            }
            super.onFrame(frame);
        }

        @Override
        protected void checkAndSetExistSurface() {
        }

        @Override
        protected void updateRenderSettings() {
        }

        @Override
        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        }
    }

    private static class TextureViewEglRenderHelper
    extends SurfaceEglRendererHelper
    implements TextureView.SurfaceTextureListener {
        TextureViewEglRenderHelper(long nativeVideoRendererAndroid, @NonNull TextureView view) {
            super(nativeVideoRendererAndroid, (View)view);
        }

        @Override
        public boolean initImpl(EglBase.Context sharedContext, RenderConfig renderConfig) {
            if (!super.initImpl(sharedContext, renderConfig)) {
                return false;
            }
            View view = (View)this.view.get();
            if (view instanceof TextureView) {
                ((TextureView)view).setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkAndSetExistSurface() {
            this.logI("checkAndSetExistSurface()");
            ThreadUtils.checkIsOnMainThread();
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    this.logE("checkAndSetExistSurface failure, disposed!");
                    return;
                }
                View view = (View)this.view.get();
                if (!(view instanceof TextureView)) {
                    this.logE("checkAndSetExistSurface failure, view error! " + view);
                    return;
                }
                SurfaceTexture surfaceTexture = ((TextureView)view).getSurfaceTexture();
                if (surfaceTexture == null) {
                    this.logE("checkAndSetExistSurface failure, surfaceTexture empty!");
                    return;
                }
                this.onSurfaceTextureAvailable(surfaceTexture, 0, 0);
                this.onSurfaceTextureSizeChanged(surfaceTexture, view.getWidth(), view.getHeight());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reInit(EglBase.Context sharedContext) {
            this.logI("reInit()");
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    return;
                }
                View view = (View)this.view.get();
                if (view instanceof TextureView) {
                    ((TextureView)view).setSurfaceTextureListener(null);
                }
                this.eglRenderer.release();
                this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
                this.eglRenderer.isRenderOnSurfaceView(false);
                this.initImpl(sharedContext, this.renderConfig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            this.logI("dispose()");
            super.dispose();
            if (this.eglRenderer == null) {
                return;
            }
            if (this.disposed) {
                return;
            }
            Object object = this.eglRenderLock;
            synchronized (object) {
                this.disposed = true;
                this.logI("setSurfaceTextureListener()");
                View view = (View)this.view.get();
                if (view instanceof TextureView) {
                    ((TextureView)view).setSurfaceTextureListener(null);
                }
                this.eglRenderer.release();
            }
            object = this.nativeLock;
            synchronized (object) {
                this.nativeVideoRendererAndroid = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            this.logI("onSurfaceTextureAvailable = " + surfaceTexture);
            ThreadUtils.checkIsOnMainThread();
            this.eglRenderer.onSurfaceTextureAvailable(surfaceTexture, width, height);
            Object object = this.nativeLock;
            synchronized (object) {
                if (this.nativeVideoRendererAndroid != 0L) {
                    this.nativeNotifyRequestLastFrame(this.nativeVideoRendererAndroid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            this.logI("onSurfaceTextureSizeChanged = " + surfaceTexture);
            this.eglRenderer.onSurfaceTextureSizeChanged(surfaceTexture, width, height);
            Object object = this.nativeLock;
            synchronized (object) {
                if (this.nativeVideoRendererAndroid != 0L) {
                    this.nativeNotifySurfaceSizeChanged(this.nativeVideoRendererAndroid, width, height);
                }
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            this.logI("onSurfaceTextureDestroyed = " + surfaceTexture);
            this.eglRenderer.onSurfaceTextureDestroyed(surfaceTexture);
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    private static class SurfaceViewEglRenderHelper
    extends SurfaceEglRendererHelper
    implements SurfaceHolder.Callback {
        SurfaceViewEglRenderHelper(long nativeRendererHelper, @NonNull SurfaceView view) {
            super(nativeRendererHelper, (View)view);
        }

        @Override
        public boolean initImpl(EglBase.Context sharedContext, RenderConfig renderConfig) {
            View view = (View)this.view.get();
            if (!(view instanceof SurfaceView)) {
                Logging.e(SurfaceEglRendererHelper.TAG, "error! view : " + view);
                return false;
            }
            SurfaceHolder holder = ((SurfaceView)view).getHolder();
            if (holder == null) {
                Logging.e(SurfaceEglRendererHelper.TAG, "error! holder is null");
                return false;
            }
            if (!super.initImpl(sharedContext, renderConfig)) {
                return false;
            }
            holder.addCallback((SurfaceHolder.Callback)this);
            holder.addCallback((SurfaceHolder.Callback)this.eglRenderer);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkAndSetExistSurface() {
            this.logI("checkAndSetExistSurface()");
            ThreadUtils.checkIsOnMainThread();
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    this.logE("checkAndSetExistSurface failure, disposed!");
                    return;
                }
                View view = (View)this.view.get();
                if (!(view instanceof SurfaceView)) {
                    this.logE("checkAndSetExistSurface failure, view error: " + view);
                    return;
                }
                SurfaceHolder holder = ((SurfaceView)view).getHolder();
                if (holder == null) {
                    this.logE("checkAndSetExistSurface failure, holder empty!");
                    return;
                }
                Surface surface = holder.getSurface();
                if (surface == null) {
                    this.logE("checkAndSetExistSurface failure, surface empty!");
                    return;
                }
                if (!surface.isValid()) {
                    this.logE("checkAndSetExistSurface failure, surface isValid!");
                    return;
                }
                this.surfaceCreated(holder);
                this.surfaceChanged(holder, 0, view.getWidth(), view.getHeight());
                this.eglRenderer.surfaceCreated(holder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reInit(EglBase.Context sharedContext) {
            this.logI("reInit()");
            Object object = this.eglRenderLock;
            synchronized (object) {
                if (this.disposed) {
                    return;
                }
                View view = (View)this.view.get();
                if (view instanceof SurfaceView) {
                    ((SurfaceView)view).getHolder().removeCallback((SurfaceHolder.Callback)this.eglRenderer);
                }
                this.eglRenderer.release();
                this.eglRenderer = new SurfaceEglRenderer(this.resourceName);
                this.eglRenderer.isRenderOnSurfaceView(true);
                this.initImpl(sharedContext, this.renderConfig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            super.dispose();
            if (this.eglRenderer == null) {
                return;
            }
            if (this.disposed) {
                return;
            }
            this.logI("dispose()");
            Object object = this.eglRenderLock;
            synchronized (object) {
                SurfaceHolder holder;
                this.disposed = true;
                View view = (View)this.view.get();
                if (view instanceof SurfaceView && (holder = ((SurfaceView)view).getHolder()) != null) {
                    holder.removeCallback((SurfaceHolder.Callback)this);
                    holder.removeCallback((SurfaceHolder.Callback)this.eglRenderer);
                }
                this.eglRenderer.release();
            }
            object = this.nativeLock;
            synchronized (object) {
                this.nativeVideoRendererAndroid = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated(SurfaceHolder holder) {
            this.logI("surfaceCreated()");
            Object object = this.nativeLock;
            synchronized (object) {
                if (this.nativeVideoRendererAndroid != 0L) {
                    this.nativeNotifyRequestLastFrame(this.nativeVideoRendererAndroid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            this.logI("surfaceChanged():" + width + " height:" + height + " format:" + format);
            Object object = this.nativeLock;
            synchronized (object) {
                if (this.nativeVideoRendererAndroid != 0L) {
                    this.nativeNotifySurfaceSizeChanged(this.nativeVideoRendererAndroid, width, height);
                }
            }
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            this.logI("surfaceDestroyed()");
        }
    }

    static @interface RenderModeType {
        public static final int RENDER_MODE_HIDDEN = 1;
        public static final int RENDER_MODE_FIT = 2;
        public static final int RENDER_MODE_ADAPTIVE = 3;
    }
}

