/*
 * Decompiled with CFR 0.152.
 */
package io.agora.utils2;

import io.agora.base.internal.CalledByNative;
import java.net.InetAddress;
import java.util.ArrayList;

class DnsParseRequest {
    private Thread parseThread = null;

    @CalledByNative
    DnsParseRequest() {
    }

    @CalledByNative
    boolean makeRequest(final long nativeHandle, final String name) {
        if (name.isEmpty()) {
            return false;
        }
        if (this.parseThread != null && this.parseThread.isAlive()) {
            return false;
        }
        this.parseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress[] addresses = InetAddress.getAllByName(name);
                    ArrayList<String> names = new ArrayList<String>();
                    for (int i = 0; i < addresses.length; ++i) {
                        names.add(addresses[i].getHostAddress());
                    }
                    DnsParseRequest.nativeResolveDoneCallback(nativeHandle, true, names, names.size());
                }
                catch (Exception ex) {
                    DnsParseRequest.nativeResolveDoneCallback(nativeHandle, false, null, 0L);
                }
            }
        });
        this.parseThread.start();
        return true;
    }

    private static native void nativeResolveDoneCallback(long var0, boolean var2, Object var3, long var4);
}

