/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.android;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.test.platform.app.InstrumentationRegistry;
import cucumber.api.CucumberOptions;
import cucumber.api.Plugin;
import cucumber.api.TypeRegistryConfigurer;
import cucumber.api.android.CucumberAndroidJUnitRunner;
import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.java.ObjectFactory;
import cucumber.runner.EventBus;
import cucumber.runner.Runner;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.Backend;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DefaultTypeRegistryConfiguration;
import cucumber.runtime.Env;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.Reflections;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.Utils;
import cucumber.runtime.android.AndroidResourceLoader;
import cucumber.runtime.android.Arguments;
import cucumber.runtime.android.DexClassFinder;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.formatter.AndroidLogcatReporter;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.formatter.Stats;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.ObjectFactoryLoader;
import cucumber.runtime.junit.AndroidFeatureRunner;
import cucumber.runtime.junit.AndroidPickleRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import dalvik.system.DexFile;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.TableRow;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import io.cucumber.core.model.GluePath;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import io.cucumber.core.options.PluginOptions;
import io.cucumber.core.options.RunnerOptions;
import io.cucumber.stepexpression.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class CucumberJUnitRunner
extends ParentRunner<AndroidFeatureRunner>
implements Filterable {
    static final String TAG = "cucumber-android";
    private static final String CUCUMBER_OPTIONS_SYSTEM_PROPERTY = "cucumber.options";
    private List<AndroidFeatureRunner> children = new ArrayList<AndroidFeatureRunner>();
    private EventBus bus;

    public CucumberJUnitRunner(Class testClass) throws InitializationError {
        super(testClass);
        CucumberAndroidJUnitRunner instrumentationRunner = (CucumberAndroidJUnitRunner)InstrumentationRegistry.getInstrumentation();
        Bundle runnerArguments = instrumentationRunner.getArguments();
        Arguments arguments = new Arguments(runnerArguments);
        CucumberJUnitRunner.trySetCucumberOptionsToSystemProperties(arguments);
        Context context = instrumentationRunner.getContext();
        ClassLoader classLoader = context.getClassLoader();
        ClassFinder classFinder = CucumberJUnitRunner.createDexClassFinder(context);
        RuntimeOptions runtimeOptions = CucumberJUnitRunner.createRuntimeOptions(context, classFinder).noSummaryPrinter();
        AndroidResourceLoader resourceLoader = new AndroidResourceLoader(context);
        this.bus = new TimeServiceEventBus(TimeService.SYSTEM);
        Plugins plugins = new Plugins(classLoader, new PluginFactory(), (EventPublisher)this.bus, (PluginOptions)runtimeOptions);
        Runner runner = new ThreadLocalRunnerSupplier((RunnerOptions)runtimeOptions, this.bus, CucumberJUnitRunner.createBackends(runtimeOptions, classFinder)).get();
        FeatureLoader featureLoader = new FeatureLoader((ResourceLoader)resourceLoader);
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(featureLoader, (FeatureOptions)runtimeOptions);
        Filters filters = new Filters((FilterOptions)runtimeOptions);
        UndefinedStepsTracker undefinedStepsTracker = new UndefinedStepsTracker();
        undefinedStepsTracker.setEventPublisher((EventPublisher)this.bus);
        Stats stats = new Stats();
        stats.setEventPublisher((EventPublisher)this.bus);
        plugins.addPlugin((Plugin)new AndroidLogcatReporter(stats, undefinedStepsTracker, TAG));
        String testClassNameFromRunner = runnerArguments.getString("cucumberAndroidTestClass");
        String requestedFeatureName = null;
        String requestedScenarioName = null;
        if (testClassNameFromRunner != null) {
            String[] split = testClassNameFromRunner.split("#");
            if (split.length > 1) {
                requestedFeatureName = split[0];
                requestedScenarioName = split[1];
            } else {
                Log.e((String)TAG, (String)("CucumberJUnitRunner: invalid argument 'cucumberAndroidTestClass' = '" + testClassNameFromRunner + "'"));
            }
        }
        List features = featureSupplier.get();
        HashSet<String> featuresNames = new HashSet<String>(features.size());
        StringBuilder duplicateScenariosNameMessage = new StringBuilder();
        this.bus.send((Event)new TestRunStarted(this.bus.getTime(), this.bus.getTimeMillis().longValue()));
        JUnitOptions junitOptions = new JUnitOptions(runtimeOptions.isStrict(), runtimeOptions.getJunitOptions());
        for (CucumberFeature feature : features) {
            feature.sendTestSourceRead(this.bus);
            String featureName = feature.getName();
            if (requestedFeatureName != null && !requestedFeatureName.equals(featureName)) continue;
            List pickles = feature.getPickles();
            ArrayList<AndroidPickleRunner> pickleRunners = new ArrayList<AndroidPickleRunner>(pickles.size());
            HashSet<String> pickleNames = new HashSet<String>(pickles.size());
            for (PickleEvent pickleEvent : pickles) {
                AndroidPickleRunner pickleRunner;
                if (!filters.matchesFilters(pickleEvent)) continue;
                String currentScenarioName = CucumberJUnitRunner.getScenarioName(pickleEvent, feature.getGherkinFeature().getFeature());
                if (pickleNames.contains(currentScenarioName)) {
                    CucumberJUnitRunner.addDuplicateScenarioMessage(duplicateScenariosNameMessage, featureName, currentScenarioName);
                }
                pickleNames.add(currentScenarioName);
                if (requestedScenarioName != null) {
                    if (!requestedScenarioName.equals(currentScenarioName)) continue;
                    pickleRunner = new AndroidPickleRunner(runner, pickleEvent, junitOptions, feature, currentScenarioName);
                    pickleRunners.add(pickleRunner);
                    this.children.add(new AndroidFeatureRunner(feature, pickleRunners));
                    CucumberJUnitRunner.throwErrorIfDuplicateScenarios(duplicateScenariosNameMessage);
                    return;
                }
                pickleRunner = new AndroidPickleRunner(runner, pickleEvent, junitOptions, feature, currentScenarioName);
                pickleRunners.add(pickleRunner);
            }
            this.addFeatureIfHasChildren(featuresNames, duplicateScenariosNameMessage, feature, featureName, pickleRunners);
        }
        CucumberJUnitRunner.throwErrorIfDuplicateScenarios(duplicateScenariosNameMessage);
    }

    private void addFeatureIfHasChildren(Collection<String> featuresNames, StringBuilder duplicateScenariosNameMessage, CucumberFeature feature, String featureName, List<AndroidPickleRunner> pickleRunners) throws InitializationError {
        if (!pickleRunners.isEmpty()) {
            if (featuresNames.contains(featureName)) {
                CucumberJUnitRunner.addDuplicateFeatureMessage(duplicateScenariosNameMessage, featureName);
            }
            featuresNames.add(featureName);
            this.children.add(new AndroidFeatureRunner(feature, pickleRunners));
        }
    }

    private static void throwErrorIfDuplicateScenarios(CharSequence duplicateScenariosNameMessage) throws InitializationError {
        if (duplicateScenariosNameMessage.length() > 0) {
            InitializationError error = new InitializationError(duplicateScenariosNameMessage.toString());
            Log.e((String)TAG, (String)"CucumberJUnitRunner: ", (Throwable)error);
            throw error;
        }
    }

    private static void addDuplicateFeatureMessage(StringBuilder duplicateScenariosNameMessage, String featureName) {
        duplicateScenariosNameMessage.append('\n').append("Duplicate feature name '").append(featureName).append("'");
    }

    private static void addDuplicateScenarioMessage(StringBuilder duplicateScenariosNameMessage, String featureName, String currentScenarioName) {
        duplicateScenariosNameMessage.append('\n').append("Duplicate scenario name '").append(currentScenarioName).append("' in feature '").append(featureName).append("'");
    }

    private static String getScenarioName(PickleEvent pickleEvent, Feature feature) {
        int exampleNumber = CucumberJUnitRunner.findExampleNumber(pickleEvent, feature);
        String pickleName = pickleEvent.pickle.getName();
        if (exampleNumber > 0) {
            return Utils.getUniqueTestNameForScenarioExample((String)pickleName, (int)exampleNumber);
        }
        return pickleName;
    }

    private static int findExampleNumber(PickleEvent pickleEvent, Feature feature) {
        int pickleLine = CucumberJUnitRunner.getLine(pickleEvent);
        for (ScenarioDefinition definition : feature.getChildren()) {
            if (!(definition instanceof ScenarioOutline)) continue;
            List examples = ((ScenarioOutline)definition).getExamples();
            int index = 0;
            for (Examples example : examples) {
                List tableBody = example.getTableBody();
                for (TableRow row : tableBody) {
                    if (row.getLocation().getLine() == pickleLine) {
                        return index + 1;
                    }
                    ++index;
                }
            }
        }
        return 0;
    }

    private static int getLine(PickleEvent pickleEvent) {
        return ((PickleLocation)pickleEvent.pickle.getLocations().get(0)).getLine();
    }

    protected List<AndroidFeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(AndroidFeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(AndroidFeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    private static void trySetCucumberOptionsToSystemProperties(Arguments arguments) {
        String cucumberOptions = arguments.getCucumberOptions();
        if (!cucumberOptions.isEmpty()) {
            Log.d((String)TAG, (String)("Setting cucumber.options from arguments: '" + cucumberOptions + "'"));
            System.setProperty(CUCUMBER_OPTIONS_SYSTEM_PROPERTY, cucumberOptions);
        }
    }

    private static ClassFinder createDexClassFinder(Context context) {
        String apkPath = context.getPackageCodePath();
        return new DexClassFinder(CucumberJUnitRunner.newDexFile(apkPath));
    }

    private static DexFile newDexFile(String apkPath) {
        try {
            return new DexFile(apkPath);
        }
        catch (IOException e) {
            throw new CucumberException("Failed to open " + apkPath);
        }
    }

    private static RuntimeOptions createRuntimeOptions(Context context, ClassFinder classFinder) {
        for (Class clazz : classFinder.getDescendants(Object.class, GluePath.parse((String)context.getPackageName()))) {
            if (!clazz.isAnnotationPresent(CucumberOptions.class)) continue;
            Log.d((String)TAG, (String)("Found CucumberOptions in class " + clazz.getName()));
            RuntimeOptionsFactory factory = new RuntimeOptionsFactory(clazz);
            return factory.create();
        }
        throw new CucumberException("No CucumberOptions annotation");
    }

    private static BackendSupplier createBackends(final RuntimeOptions runtimeOptions, final ClassFinder classFinder) {
        return new BackendSupplier(){

            public Collection<? extends Backend> get() {
                Reflections reflections = new Reflections(classFinder);
                ObjectFactory delegateObjectFactory = ObjectFactoryLoader.loadObjectFactory((ClassFinder)classFinder, (String)Env.INSTANCE.get(ObjectFactory.class.getName()));
                TypeRegistryConfigurer typeRegistryConfigurer = (TypeRegistryConfigurer)reflections.instantiateExactlyOneSubclass(TypeRegistryConfigurer.class, runtimeOptions.getGlue(), new Class[0], new Object[0], (Object)new DefaultTypeRegistryConfiguration());
                TypeRegistry typeRegistry = new TypeRegistry(typeRegistryConfigurer.locale());
                typeRegistryConfigurer.configureTypeRegistry((cucumber.api.TypeRegistry)typeRegistry);
                return Collections.singletonList(new JavaBackend(delegateObjectFactory, classFinder, typeRegistry));
            }
        };
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        final Statement features = super.childrenInvoker(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                features.evaluate();
                CucumberJUnitRunner.this.bus.send((Event)new TestRunFinished(CucumberJUnitRunner.this.bus.getTime(), CucumberJUnitRunner.this.bus.getTimeMillis().longValue()));
            }
        };
    }
}

