/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import io.druid.math.expr.BinaryOpExprBase;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class BinaryEvalOpExprBase
extends BinaryOpExprBase {
    public BinaryEvalOpExprBase(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval leftVal = this.left.eval(bindings);
        ExprEval rightVal = this.right.eval(bindings);
        if (leftVal.type() == ExprType.STRING && rightVal.type() == ExprType.STRING) {
            return this.evalString(leftVal.asString(), rightVal.asString());
        }
        if (leftVal.type() == ExprType.LONG && rightVal.type() == ExprType.LONG) {
            return ExprEval.of(this.evalLong(leftVal.asLong(), rightVal.asLong()));
        }
        return ExprEval.of(this.evalDouble(leftVal.asDouble(), rightVal.asDouble()));
    }

    protected ExprEval evalString(@Nullable String left, @Nullable String right) {
        throw new IllegalArgumentException("unsupported type " + (Object)((Object)ExprType.STRING));
    }

    protected abstract long evalLong(long var1, long var3);

    protected abstract double evalDouble(double var1, double var3);
}

