/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import io.druid.java.util.common.IAE;
import io.druid.math.expr.Expr;
import io.druid.math.expr.ExprEval;
import io.druid.math.expr.ExprType;
import io.druid.math.expr.UnaryExpr;
import javax.annotation.Nonnull;

class UnaryMinusExpr
extends UnaryExpr {
    UnaryMinusExpr(Expr expr) {
        super(expr);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval ret = this.expr.eval(bindings);
        if (ret.type() == ExprType.LONG) {
            return ExprEval.of(-ret.asLong());
        }
        if (ret.type() == ExprType.DOUBLE) {
            return ExprEval.of(-ret.asDouble());
        }
        throw new IAE("unsupported type " + (Object)((Object)ret.type()), new Object[0]);
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        this.expr.visit(visitor);
        visitor.visit(this);
    }

    public String toString() {
        return "-" + this.expr.toString();
    }
}

