/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.java.util.common.StringUtils;
import io.druid.metadata.PasswordProvider;

public class MetadataStorageConnectorConfig {
    @JsonProperty
    private boolean createTables = true;
    @JsonProperty
    private String host = "localhost";
    @JsonProperty
    private int port = 1527;
    @JsonProperty
    private String connectURI;
    @JsonProperty
    private String user = null;
    @JsonProperty(value="password")
    private PasswordProvider passwordProvider;

    public boolean isCreateTables() {
        return this.createTables;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getConnectURI() {
        if (this.connectURI == null) {
            return StringUtils.format((String)"jdbc:derby://%s:%s/druid;create=true", (Object[])new Object[]{this.host, this.port});
        }
        return this.connectURI;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.passwordProvider == null ? null : this.passwordProvider.getPassword();
    }

    public String toString() {
        return "DbConnectorConfig{createTables=" + this.createTables + ", connectURI='" + this.getConnectURI() + '\'' + ", user='" + this.user + '\'' + ", passwordProvider=" + this.passwordProvider + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetadataStorageConnectorConfig)) {
            return false;
        }
        MetadataStorageConnectorConfig that = (MetadataStorageConnectorConfig)o;
        if (this.isCreateTables() != that.isCreateTables()) {
            return false;
        }
        if (this.getPort() != that.getPort()) {
            return false;
        }
        if (this.getHost() != null ? !this.getHost().equals(that.getHost()) : that.getHost() != null) {
            return false;
        }
        if (this.getConnectURI() != null ? !this.getConnectURI().equals(that.getConnectURI()) : that.getConnectURI() != null) {
            return false;
        }
        if (this.getUser() != null ? !this.getUser().equals(that.getUser()) : that.getUser() != null) {
            return false;
        }
        return this.passwordProvider != null ? this.passwordProvider.equals(that.passwordProvider) : that.passwordProvider == null;
    }

    public int hashCode() {
        int result = this.isCreateTables() ? 1 : 0;
        result = 31 * result + (this.getHost() != null ? this.getHost().hashCode() : 0);
        result = 31 * result + this.getPort();
        result = 31 * result + (this.getConnectURI() != null ? this.getConnectURI().hashCode() : 0);
        result = 31 * result + (this.getUser() != null ? this.getUser().hashCode() : 0);
        result = 31 * result + (this.passwordProvider != null ? this.passwordProvider.hashCode() : 0);
        return result;
    }
}

