/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import io.druid.timeline.partition.PartitionChunk;

public class StringPartitionChunk<T>
implements PartitionChunk<T> {
    private final String start;
    private final String end;
    private final int chunkNumber;
    private final T object;

    public static <T> StringPartitionChunk<T> make(String start, String end, int chunkNumber, T obj) {
        return new StringPartitionChunk<T>(start, end, chunkNumber, obj);
    }

    public StringPartitionChunk(String start, String end, int chunkNumber, T object) {
        this.start = start;
        this.end = end;
        this.chunkNumber = chunkNumber;
        this.object = object;
    }

    public T getObject() {
        return this.object;
    }

    public boolean abuts(PartitionChunk<T> chunk) {
        if (chunk instanceof StringPartitionChunk) {
            StringPartitionChunk stringChunk = (StringPartitionChunk)chunk;
            return !stringChunk.isStart() && stringChunk.start.equals(this.end);
        }
        return false;
    }

    public boolean isStart() {
        return this.start == null;
    }

    public boolean isEnd() {
        return this.end == null;
    }

    public int getChunkNumber() {
        return this.chunkNumber;
    }

    public int compareTo(PartitionChunk<T> chunk) {
        if (chunk instanceof StringPartitionChunk) {
            StringPartitionChunk stringChunk = (StringPartitionChunk)chunk;
            return Integer.compare(this.chunkNumber, stringChunk.chunkNumber);
        }
        throw new IllegalArgumentException("Cannot compare against something that is not a StringPartitionChunk.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((StringPartitionChunk)o) == 0;
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.object != null ? this.object.hashCode() : 0);
        return result;
    }
}

