/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.time;

import androidx.compose.animation.core.Easing;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.util.MathHelpersKt;
import io.github.alexzhirkevich.compottie.dynamic.PropertyProviderKt;
import io.github.alexzhirkevich.compottie.internal.AnimationState;
import io.github.alexzhirkevich.compottie.internal.animation.RawProperty;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.EvaluationContext;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.Expression;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.ExpressionContextKt;
import io.github.alexzhirkevich.compottie.internal.animation.expressions.operations.value.OpConstantKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B7\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/github/alexzhirkevich/compottie/internal/animation/expressions/operations/time/OpInterpolate;", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;", "t", "tMin", "tMax", "value1", "value2", "easing", "Landroidx/compose/animation/core/Easing;", "<init>", "(Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;Landroidx/compose/animation/core/Easing;)V", "invoke", "", "property", "Lio/github/alexzhirkevich/compottie/internal/animation/RawProperty;", "context", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/EvaluationContext;", "state", "Lio/github/alexzhirkevich/compottie/internal/AnimationState;", "fraction", "", "a", "b", "time", "interpolate", "Companion", "compottie_release"})
@StabilityInferred(parameters=1)
public final class OpInterpolate
implements Expression {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Expression t;
    @NotNull
    private final Expression tMin;
    @NotNull
    private final Expression tMax;
    @NotNull
    private final Expression value1;
    @NotNull
    private final Expression value2;
    @NotNull
    private final Easing easing;
    public static final int $stable;

    public OpInterpolate(@NotNull Expression t, @NotNull Expression tMin, @NotNull Expression tMax, @NotNull Expression value1, @NotNull Expression value2, @NotNull Easing easing) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)tMin, (String)"tMin");
        Intrinsics.checkNotNullParameter((Object)tMax, (String)"tMax");
        Intrinsics.checkNotNullParameter((Object)value1, (String)"value1");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value2");
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.t = t;
        this.tMin = tMin;
        this.tMax = tMax;
        this.value1 = value1;
        this.value2 = value2;
        this.easing = easing;
    }

    @Override
    @NotNull
    public Object invoke(@NotNull RawProperty<? extends Object> property, @NotNull EvaluationContext context, @NotNull AnimationState state) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Object object = this.t.invoke(property, context, state);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
        float t = ((Number)object).floatValue();
        Object object2 = this.tMin.invoke(property, context, state);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Number");
        float tMin = ((Number)object2).floatValue();
        Object object3 = this.tMax.invoke(property, context, state);
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Number");
        float tMAx = ((Number)object3).floatValue();
        Object value1 = this.value1.invoke(property, context, state);
        Object value2 = this.value2.invoke(property, context, state);
        return t <= tMin ? value1 : (t >= tMAx ? value2 : this.interpolate(value1, value2, this.fraction(tMin, tMAx, t)));
    }

    private final float fraction(float a, float b, float time) {
        return this.easing.transform((time - a) / (b - a));
    }

    private final Object interpolate(Object value1, Object value2, float fraction) {
        if (value1 instanceof Number && value2 instanceof Number) {
            return Float.valueOf(MathHelpersKt.lerp((float)((Number)value1).floatValue(), (float)((Number)value2).floatValue(), (float)fraction));
        }
        if (!(value1 instanceof Offset) || !(value2 instanceof Offset)) {
            throw new IllegalStateException(("Cant interpolate between " + value1 + " and " + value2).toString());
        }
        return Offset.box-impl((long)OffsetKt.lerp-Wko1d7g((long)PropertyProviderKt.toOffset-k-4lQ0M(((Offset)value1).unbox-impl()), (long)PropertyProviderKt.toOffset-k-4lQ0M(((Offset)value2).unbox-impl()), (float)fraction));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lio/github/alexzhirkevich/compottie/internal/animation/expressions/operations/time/OpInterpolate$Companion;", "", "<init>", "()V", "interpret", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/operations/time/OpInterpolate;", "easing", "Landroidx/compose/animation/core/Easing;", "args", "", "Lio/github/alexzhirkevich/compottie/internal/animation/expressions/Expression;", "compottie_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OpInterpolate interpret(@NotNull Easing easing, @NotNull List<? extends Expression> args) {
            OpInterpolate opInterpolate;
            Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            switch (args.size()) {
                case 3: {
                    String[] stringArray = new String[]{"t"};
                    Expression expression = ExpressionContextKt.argForNameOrIndex(args, 0, stringArray);
                    Intrinsics.checkNotNull((Object)expression);
                    Expression expression2 = OpConstantKt.OpConstant(Float.valueOf(0.0f));
                    Expression expression3 = OpConstantKt.OpConstant(Float.valueOf(1.0f));
                    stringArray = new String[]{"value1"};
                    Expression expression4 = ExpressionContextKt.argForNameOrIndex(args, 1, stringArray);
                    Intrinsics.checkNotNull((Object)expression4);
                    stringArray = new String[]{"value2"};
                    Expression expression5 = ExpressionContextKt.argForNameOrIndex(args, 2, stringArray);
                    Intrinsics.checkNotNull((Object)expression5);
                    opInterpolate = new OpInterpolate(expression, expression2, expression3, expression4, expression5, easing);
                    break;
                }
                case 5: {
                    String[] stringArray = new String[]{"t"};
                    Expression expression = ExpressionContextKt.argForNameOrIndex(args, 0, stringArray);
                    Intrinsics.checkNotNull((Object)expression);
                    stringArray = new String[]{"tMin"};
                    Expression expression6 = ExpressionContextKt.argForNameOrIndex(args, 1, stringArray);
                    Intrinsics.checkNotNull((Object)expression6);
                    stringArray = new String[]{"tMax"};
                    Expression expression7 = ExpressionContextKt.argForNameOrIndex(args, 2, stringArray);
                    Intrinsics.checkNotNull((Object)expression7);
                    stringArray = new String[]{"value1"};
                    Expression expression8 = ExpressionContextKt.argForNameOrIndex(args, 3, stringArray);
                    Intrinsics.checkNotNull((Object)expression8);
                    stringArray = new String[]{"value2"};
                    Expression expression9 = ExpressionContextKt.argForNameOrIndex(args, 4, stringArray);
                    Intrinsics.checkNotNull((Object)expression9);
                    opInterpolate = new OpInterpolate(expression, expression6, expression7, expression8, expression9, easing);
                    break;
                }
                default: {
                    throw new IllegalStateException(("interpolation function can take 3 or 5 arguments but got " + args.size()).toString());
                }
            }
            return opInterpolate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

