/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.helpers;

import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Path;
import io.github.alexzhirkevich.compottie.internal.AnimationState;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedNumberKt;
import io.github.alexzhirkevich.compottie.internal.content.Content;
import io.github.alexzhirkevich.compottie.internal.helpers.CompoundTrimPath;
import io.github.alexzhirkevich.compottie.internal.platform.ExtendedPathMeasure;
import io.github.alexzhirkevich.compottie.internal.platform.PlatformPathKt;
import io.github.alexzhirkevich.compottie.internal.platform.PlatformPath_androidKt;
import io.github.alexzhirkevich.compottie.internal.shapes.TrimPathShape;
import io.github.alexzhirkevich.compottie.internal.shapes.TrimPathShapeKt;
import io.github.alexzhirkevich.compottie.internal.utils.MiscUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a$\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0000\"\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\"\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"CompoundSimultaneousTrimPath", "Lio/github/alexzhirkevich/compottie/internal/helpers/CompoundTrimPath;", "contents", "", "Lio/github/alexzhirkevich/compottie/internal/content/Content;", "applyTrimPath", "", "Landroidx/compose/ui/graphics/Path;", "trimPath", "Lio/github/alexzhirkevich/compottie/internal/shapes/TrimPathShape;", "state", "Lio/github/alexzhirkevich/compottie/internal/AnimationState;", "pathMeasure", "Lio/github/alexzhirkevich/compottie/internal/platform/ExtendedPathMeasure;", "getPathMeasure", "()Lio/github/alexzhirkevich/compottie/internal/platform/ExtendedPathMeasure;", "pathMeasure$delegate", "Lkotlin/Lazy;", "tempPath", "tempPath2", "startValue", "", "endValue", "offsetValue", "compottie_release"})
@SourceDebugExtension(value={"SMAP\nCompoundTrimPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompoundTrimPath.kt\nio/github/alexzhirkevich/compottie/internal/helpers/CompoundTrimPathKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n808#2,11:137\n235#3,3:148\n33#3,4:151\n238#3,2:155\n38#3:157\n240#3:158\n1#4:159\n*S KotlinDebug\n*F\n+ 1 CompoundTrimPath.kt\nio/github/alexzhirkevich/compottie/internal/helpers/CompoundTrimPathKt\n*L\n31#1:137,11\n32#1:148,3\n32#1:151,4\n32#1:155,2\n32#1:157\n32#1:158\n*E\n"})
public final class CompoundTrimPathKt {
    @NotNull
    private static final Lazy pathMeasure$delegate = LazyKt.lazy(CompoundTrimPathKt::pathMeasure_delegate$lambda$2);
    @NotNull
    private static final Path tempPath = AndroidPath_androidKt.Path();
    @NotNull
    private static final Path tempPath2 = AndroidPath_androidKt.Path();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CompoundTrimPath CompoundSimultaneousTrimPath(@NotNull List<? extends Content> contents) {
        CompoundTrimPath compoundTrimPath;
        List list;
        List list2;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        Iterable $this$filterIsInstance$iv = contents;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TrimPathShape)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$fastFilter$iv = (List)destination$iv$iv;
        boolean $i$f$fastFilter = false;
        ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
        List $this$fastForEach$iv$iv = $this$fastFilter$iv;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            Object item$iv$iv;
            Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            Content p0 = (Content)it$iv;
            boolean $i$f$CompoundSimultaneousTrimPath$stub_for_inlining = false;
            boolean bl2 = false;
            if (!TrimPathShapeKt.isSimultaneousTrimPath(p0)) continue;
            ((Collection)target$iv).add(it$iv);
        }
        List p0 = list2 = (List)target$iv;
        boolean $i$f$CompoundSimultaneousTrimPath$stub_for_inlining$0 = false;
        boolean bl = false;
        List list3 = list = !((Collection)p0).isEmpty() ? list2 : null;
        if (list != null) {
            List it = list;
            boolean bl3 = false;
            compoundTrimPath = new CompoundTrimPath(it);
        } else {
            compoundTrimPath = null;
        }
        return compoundTrimPath;
    }

    public static final void applyTrimPath(@NotNull Path $this$applyTrimPath, @NotNull TrimPathShape trimPath, @NotNull AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)$this$applyTrimPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)trimPath, (String)"trimPath");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (trimPath.isHidden(state)) {
            return;
        }
        float start = AnimatedNumberKt.interpolatedNorm(trimPath.getStart(), state);
        float end = AnimatedNumberKt.interpolatedNorm(trimPath.getEnd(), state);
        float offset = ((Number)trimPath.getOffset().interpolated(state)).floatValue();
        CompoundTrimPathKt.applyTrimPath($this$applyTrimPath, start, end, offset / 360.0f);
    }

    private static final ExtendedPathMeasure getPathMeasure() {
        Lazy lazy = pathMeasure$delegate;
        return (ExtendedPathMeasure)lazy.getValue();
    }

    public static final void applyTrimPath(@NotNull Path $this$applyTrimPath, float startValue, float endValue, float offsetValue) {
        Intrinsics.checkNotNullParameter((Object)$this$applyTrimPath, (String)"<this>");
        CompoundTrimPathKt.getPathMeasure().setPath($this$applyTrimPath, false);
        float length = CompoundTrimPathKt.getPathMeasure().getLength();
        if (startValue == 1.0f && endValue == 0.0f) {
            return;
        }
        if (length < 1.0f || Math.abs(endValue - startValue - 1.0f) < 0.01f) {
            return;
        }
        float start = length * startValue;
        float end = length * endValue;
        float newStart = Math.min(start, end);
        float newEnd = Math.max(start, end);
        float offset = offsetValue * length;
        newStart += offset;
        newEnd += offset;
        if (newStart >= length && newEnd >= length) {
            newStart = MiscUtilKt.floorMod(newStart, length);
            newEnd = MiscUtilKt.floorMod(newEnd, length);
        }
        if (newStart < 0.0f) {
            newStart = MiscUtilKt.floorMod(newStart, length);
        }
        if (newEnd < 0.0f) {
            newEnd = MiscUtilKt.floorMod(newEnd, length);
        }
        if (newStart == newEnd) {
            $this$applyTrimPath.reset();
            return;
        }
        if (newStart >= newEnd) {
            newStart -= length;
        }
        tempPath.reset();
        CompoundTrimPathKt.getPathMeasure().getSegment(newStart, newEnd, tempPath, true);
        if (newEnd > length) {
            tempPath2.reset();
            CompoundTrimPathKt.getPathMeasure().getSegment(0.0f, newEnd % length, tempPath2, true);
            Path.addPath-Uv8p0NA$default((Path)tempPath, (Path)tempPath2, (long)0L, (int)2, null);
        } else if (newStart < 0.0f) {
            tempPath2.reset();
            CompoundTrimPathKt.getPathMeasure().getSegment(length + newStart, length, tempPath2, true);
            Path.addPath-Uv8p0NA$default((Path)tempPath, (Path)tempPath2, (long)0L, (int)2, null);
        }
        PlatformPathKt.set($this$applyTrimPath, tempPath);
    }

    private static final ExtendedPathMeasure pathMeasure_delegate$lambda$2() {
        return PlatformPath_androidKt.ExtendedPathMeasure();
    }
}

