/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.adapter.web.listener;

import com.dtp.adapter.web.handler.WebServerTpHandler;
import com.dtp.common.ApplicationContextHolder;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.dto.ThreadPoolStats;
import com.dtp.common.event.CollectEvent;
import com.dtp.core.handler.CollectorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class DtpWebCollectListener
implements ApplicationListener<CollectEvent> {
    private static final Logger log = LoggerFactory.getLogger(DtpWebCollectListener.class);

    public void onApplicationEvent(CollectEvent event) {
        DtpProperties dtpProperties = event.getDtpProperties();
        if (!dtpProperties.isEnabledCollect()) {
            return;
        }
        try {
            WebServerTpHandler webServerTpHandler = (WebServerTpHandler)ApplicationContextHolder.getBean(WebServerTpHandler.class);
            ThreadPoolStats poolStats = webServerTpHandler.getPoolStats();
            if (poolStats == null) {
                return;
            }
            CollectorHandler.getInstance().collect(poolStats, dtpProperties.getCollectorType());
        }
        catch (Exception e) {
            log.error("DynamicTp monitor, collect web server thread pool metrics failed.", (Throwable)e);
        }
    }
}

