/*
 * Decompiled with CFR 0.152.
 */
package io.github.mymonstercat;

import io.github.mymonstercat.JarFileUtil;

public enum Model {
    ONNX_PPOCR_V3("/models", "onnx", "ch_PP-OCRv3_det_infer.onnx", "ch_ppocr_mobile_v2.0_cls_infer.onnx", "ch_PP-OCRv3_rec_infer.onnx", "ppocr_keys_v1.txt"),
    ONNX_PPOCR_V4("/models", "onnx", "ch_PP-OCRv4_det_infer.onnx", "ch_ppocr_mobile_v2.0_cls_infer.onnx", "ch_PP-OCRv4_rec_infer.onnx", "ppocr_keys_v1.txt"),
    NCNN_PPOCR_V3("/models", "ncnn", "ch_PP-OCRv3_det_infer", "ch_ppocr_mobile_v2.0_cls_infer", "ch_PP-OCRv3_rec_infer", "ppocr_keys_v1.txt");

    private final String modelsDir;
    private final String modelType;
    private final String detName;
    private final String clsName;
    private final String recName;
    private final String keysName;

    private Model(String modelsDir, String modelType, String detName, String clsName, String recName, String keysName) {
        this.modelsDir = modelsDir;
        this.modelType = modelType;
        this.detName = detName;
        this.clsName = clsName;
        this.recName = recName;
        this.keysName = keysName;
    }

    public String getTempDirPath() {
        return JarFileUtil.TEMP_DIR + "/" + this.modelType;
    }

    public String[] getModelFileArray() {
        if (this.modelType.equals("onnx")) {
            return new String[]{this.detName, this.clsName, this.recName, this.keysName};
        }
        String bin = ".bin";
        String param = ".param";
        return new String[]{this.detName + ".bin", this.detName + ".param", this.clsName + ".bin", this.clsName + ".param", this.recName + ".bin", this.recName + ".param", this.keysName};
    }

    public String getModelsDir() {
        return this.modelsDir;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getDetName() {
        return this.detName;
    }

    public String getClsName() {
        return this.clsName;
    }

    public String getRecName() {
        return this.recName;
    }

    public String getKeysName() {
        return this.keysName;
    }

    public String toString() {
        return "Model." + this.name() + "(modelsDir=" + this.getModelsDir() + ", modelType=" + this.getModelType() + ", detName=" + this.getDetName() + ", clsName=" + this.getClsName() + ", recName=" + this.getRecName() + ", keysName=" + this.getKeysName() + ")";
    }
}

