/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.lifecycle.Observer;
import java.lang.ref.WeakReference;
import razerdp.basepopup.FirstOpenActivityLiveData;

public final class BasePopupSDK {
    private static volatile Application mApplicationContext;
    private WeakReference<Activity> mTopActivity;
    private FirstOpenActivityLiveData<Boolean> firstActivityOpenLiveData;

    void regFirstActivityOpen(Observer<Boolean> observer) {
        if (this.firstActivityOpenLiveData == null) {
            this.firstActivityOpenLiveData = new FirstOpenActivityLiveData();
        }
        this.firstActivityOpenLiveData.observeForever(observer);
    }

    private BasePopupSDK() {
    }

    synchronized void init(Context context) {
        if (mApplicationContext != null) {
            return;
        }
        mApplicationContext = (Application)context.getApplicationContext();
        this.regLifeCallback();
    }

    public Activity getTopActivity() {
        return this.mTopActivity == null ? null : (Activity)this.mTopActivity.get();
    }

    private void regLifeCallback() {
        mApplicationContext.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                BasePopupSDK.this.recordTopActivity(activity);
            }

            public void onActivityStarted(Activity activity) {
                BasePopupSDK.this.recordTopActivity(activity);
            }

            public void onActivityResumed(Activity activity) {
                BasePopupSDK.this.recordTopActivity(activity);
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    private void recordTopActivity(Activity act) {
        if (this.mTopActivity != null) {
            if (this.mTopActivity.get() == act) {
                return;
            }
            this.mTopActivity.clear();
        }
        boolean isFirstActivityOpened = this.mTopActivity == null;
        this.mTopActivity = new WeakReference<Activity>(act);
        if (isFirstActivityOpened && this.firstActivityOpenLiveData != null) {
            this.firstActivityOpenLiveData.setValue(true);
            this.firstActivityOpenLiveData.clear();
            this.firstActivityOpenLiveData = null;
        }
    }

    public static BasePopupSDK getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static Application getApplication() {
        return mApplicationContext;
    }

    private static class SingletonHolder {
        private static final BasePopupSDK INSTANCE = new BasePopupSDK();

        private SingletonHolder() {
        }
    }
}

