/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Pair;
import android.view.View;
import android.view.animation.Animation;
import androidx.annotation.Keep;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import razerdp.basepopup.BasePopupFlag;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.blur.PopupBlurOption;
import razerdp.util.KeyboardUtils;
import razerdp.util.animation.AnimationHelper;
import razerdp.util.animation.ScaleConfig;
import razerdp.util.log.PopupLog;
import razerdp.widget.QuickPopup;

@Keep
public class QuickPopupConfig
implements BasePopupFlag,
ClearMemoryObject {
    static final Map<String, Method> INVOKE_MAP = new HashMap<String, Method>();
    protected Map<String, Object> invokeParams;
    protected int contentViewLayoutid;
    public int flag = 151916733;
    protected BasePopupWindow.OnBlurOptionInitListener mOnBlurOptionInitListener;
    protected PopupBlurOption mPopupBlurOption;
    HashMap<Integer, Pair<View.OnClickListener, Boolean>> mListenersHolderMap;
    volatile boolean destroyed;

    static Class<?> getClass(Object obj) {
        if (obj instanceof Integer) {
            return Integer.TYPE;
        }
        if (obj instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (obj instanceof Double) {
            return Double.TYPE;
        }
        if (obj instanceof Float) {
            return Float.class;
        }
        if (obj instanceof Long) {
            return Long.TYPE;
        }
        if (obj instanceof Animation) {
            return Animation.class;
        }
        if (obj instanceof Animator) {
            return Animator.class;
        }
        if (obj instanceof Drawable) {
            return Drawable.class;
        }
        return obj.getClass();
    }

    static boolean AppendInvokeMap(String name, Class<?> paramClass) {
        if (INVOKE_MAP.containsKey(name)) {
            return true;
        }
        Method m = QuickPopupConfig.FindMethod(name, paramClass);
        if (m != null) {
            INVOKE_MAP.put(name, m);
            return true;
        }
        return false;
    }

    static Method FindMethod(String methodName, Class<?> parameterTypes) {
        try {
            return QuickPopup.class.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            PopupLog.e("not found", methodName, parameterTypes.getName());
            return null;
        }
    }

    void set(String name, Object obj) {
        if (QuickPopupConfig.AppendInvokeMap(name, QuickPopupConfig.getClass(obj))) {
            this.invokeParams.put(name, obj);
        }
    }

    public QuickPopupConfig() {
        if (Build.VERSION.SDK_INT == 23) {
            this.flag &= 0xFFFFFF7F;
        }
        this.invokeParams = new HashMap<String, Object>();
    }

    public static QuickPopupConfig generateDefault() {
        return new QuickPopupConfig().withShowAnimation(((AnimationHelper.AnimationBuilder)AnimationHelper.asAnimation().withScale(ScaleConfig.CENTER)).toShow()).withDismissAnimation(((AnimationHelper.AnimationBuilder)AnimationHelper.asAnimation().withScale(ScaleConfig.CENTER)).toDismiss()).fadeInAndOut(Build.VERSION.SDK_INT != 23);
    }

    public QuickPopupConfig withShowAnimation(Animation showAnimation) {
        this.set("setShowAnimation", showAnimation);
        return this;
    }

    public QuickPopupConfig withDismissAnimation(Animation dismissAnimation) {
        this.set("setDismissAnimation", dismissAnimation);
        return this;
    }

    public QuickPopupConfig withShowAnimator(Animator showAnimator) {
        this.set("setShowAnimator", showAnimator);
        return this;
    }

    public QuickPopupConfig withDismissAnimator(Animator dismissAnimator) {
        this.set("setDismissAnimator", dismissAnimator);
        return this;
    }

    public QuickPopupConfig dismissListener(BasePopupWindow.OnDismissListener dismissListener) {
        this.set("setOnDismissListener", dismissListener);
        return this;
    }

    public QuickPopupConfig blurBackground(boolean blurBackground) {
        return this.blurBackground(blurBackground, null);
    }

    public QuickPopupConfig blurBackground(boolean blurBackground, BasePopupWindow.OnBlurOptionInitListener mInitListener) {
        this.setFlag(16384, blurBackground);
        this.mOnBlurOptionInitListener = mInitListener;
        return this;
    }

    public QuickPopupConfig withBlurOption(PopupBlurOption popupBlurOption) {
        this.mPopupBlurOption = popupBlurOption;
        return this;
    }

    public QuickPopupConfig withClick(int viewId, View.OnClickListener listener) {
        return this.withClick(viewId, listener, false);
    }

    public QuickPopupConfig withClick(int viewId, View.OnClickListener listener, boolean dismissWhenClick) {
        if (this.mListenersHolderMap == null) {
            this.mListenersHolderMap = new HashMap();
        }
        this.mListenersHolderMap.put(viewId, (Pair<View.OnClickListener, Boolean>)Pair.create((Object)listener, (Object)dismissWhenClick));
        return this;
    }

    public QuickPopupConfig fadeInAndOut(boolean fadeEnable) {
        this.setFlag(128, fadeEnable);
        return this;
    }

    public QuickPopupConfig offsetX(int offsetX) {
        this.set("setOffsetX", offsetX);
        return this;
    }

    public QuickPopupConfig maskOffsetX(int offsetX) {
        this.set("setMaskOffsetX", offsetX);
        return this;
    }

    public QuickPopupConfig offsetY(int offsetY) {
        this.set("setOffsetY", offsetY);
        return this;
    }

    public QuickPopupConfig maskOffsetY(int offsetY) {
        this.set("setMaskOffsetY", offsetY);
        return this;
    }

    public QuickPopupConfig overlayStatusbarMode(int mode) {
        this.set("setOverlayStatusbarMode", mode);
        return this;
    }

    public QuickPopupConfig overlayNavigationBarMode(int mode) {
        this.set("setOverlayNavigationBarMode", mode);
        return this;
    }

    public QuickPopupConfig overlayStatusbar(boolean overlay) {
        this.set("setOverlayStatusbar", overlay);
        return this;
    }

    public QuickPopupConfig overlayNavigationBar(boolean overlay) {
        this.set("setOverlayNavigationBar", overlay);
        return this;
    }

    public QuickPopupConfig alignBackground(boolean alignBackground) {
        this.set("setAlignBackground", alignBackground);
        return this;
    }

    public QuickPopupConfig alignBackgroundGravity(int gravity) {
        this.set("setAlignBackgroundGravity", gravity);
        return this;
    }

    public QuickPopupConfig autoMirrorEnable(boolean autoMirrorEnable) {
        this.set("setAutoMirrorEnable", autoMirrorEnable);
        return this;
    }

    public QuickPopupConfig background(Drawable background) {
        this.set("setBackground", background);
        return this;
    }

    public QuickPopupConfig backgroundColor(int color) {
        return this.background((Drawable)new ColorDrawable(color));
    }

    public QuickPopupConfig gravity(int gravity) {
        this.set("setPopupGravity", gravity);
        return this;
    }

    public QuickPopupConfig clipChildren(boolean clipChildren) {
        this.set("setClipChildren", clipChildren);
        return this;
    }

    public QuickPopupConfig outSideTouchable(boolean outSideTouchable) {
        this.set("setOutSideTouchable", outSideTouchable);
        return this;
    }

    public QuickPopupConfig linkTo(View linkedView) {
        this.set("linkTo", linkedView);
        return this;
    }

    QuickPopupConfig contentViewLayoutid(int contentViewLayoutid) {
        this.contentViewLayoutid = contentViewLayoutid;
        return this;
    }

    public QuickPopupConfig minWidth(int minWidth) {
        this.set("setMinWidth", minWidth);
        return this;
    }

    public QuickPopupConfig maxWidth(int maxWidth) {
        this.set("setMaxWidth", maxWidth);
        return this;
    }

    public QuickPopupConfig minHeight(int minHeight) {
        this.set("setMinHeight", minHeight);
        return this;
    }

    public QuickPopupConfig maxHeight(int maxHeight) {
        this.set("setMaxHeight", maxHeight);
        return this;
    }

    public QuickPopupConfig backpressEnable(boolean enable) {
        this.set("setBackPressEnable", enable);
        return this;
    }

    public QuickPopupConfig outSideDismiss(boolean outsideDismiss) {
        this.set("setOutSideDismiss", outsideDismiss);
        return this;
    }

    public QuickPopupConfig keyEventListener(BasePopupWindow.KeyEventListener keyEventListener) {
        this.set("setKeyEventListener", keyEventListener);
        return this;
    }

    public QuickPopupConfig keyBoardChangeListener(KeyboardUtils.OnKeyboardChangeListener listener) {
        this.set("setOnKeyboardChangeListener", listener);
        return this;
    }

    public Map<String, Object> getInvokeParams() {
        return this.invokeParams;
    }

    public Method getMethod(String name) {
        if (INVOKE_MAP.containsKey(name)) {
            return INVOKE_MAP.get(name);
        }
        return null;
    }

    public PopupBlurOption getPopupBlurOption() {
        return this.mPopupBlurOption;
    }

    public HashMap<Integer, Pair<View.OnClickListener, Boolean>> getListenersHolderMap() {
        return this.mListenersHolderMap;
    }

    public BasePopupWindow.OnBlurOptionInitListener getOnBlurOptionInitListener() {
        return this.mOnBlurOptionInitListener;
    }

    public int getContentViewLayoutid() {
        return this.contentViewLayoutid;
    }

    private void setFlag(int flag, boolean added) {
        this.flag = !added ? (this.flag &= ~flag) : (this.flag |= flag);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void clear(boolean destroy) {
        this.destroyed = true;
        if (this.mPopupBlurOption != null) {
            this.mPopupBlurOption.clear();
        }
        this.mOnBlurOptionInitListener = null;
        if (this.mListenersHolderMap != null) {
            this.mListenersHolderMap.clear();
        }
        this.mListenersHolderMap = null;
        this.invokeParams.clear();
        this.invokeParams = null;
    }
}

