/*
 * Decompiled with CFR 0.152.
 */
package razerdp.blur;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.view.View;
import android.widget.Toast;
import razerdp.blur.FastBlur;
import razerdp.util.PopupUiUtils;
import razerdp.util.log.PopupLog;

public class BlurHelper {
    private static final String TAG = "BlurHelper";
    private static long startTime;
    private static volatile RenderScript SCRIPT_INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static RenderScript getScriptInstance(Context context) {
        if (SCRIPT_INSTANCE != null) return SCRIPT_INSTANCE;
        Class<BlurHelper> clazz = BlurHelper.class;
        synchronized (BlurHelper.class) {
            if (SCRIPT_INSTANCE != null) return SCRIPT_INSTANCE;
            SCRIPT_INSTANCE = RenderScript.create((Context)context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SCRIPT_INSTANCE;
        }
    }

    public static boolean renderScriptSupported() {
        return Build.VERSION.SDK_INT > 17;
    }

    public static Bitmap blur(Context context, View view, float scaledRatio, float radius) {
        return BlurHelper.blur(context, view, scaledRatio, radius, true);
    }

    public static Bitmap blur(Context context, View view, float scaledRatio, float radius, boolean fullScreen) {
        return BlurHelper.blur(context, view, scaledRatio, radius, fullScreen, 0, 0);
    }

    public static Bitmap blur(Context context, View view, float scaledRatio, float radius, boolean fullScreen, int cutoutX, int cutoutY) {
        return BlurHelper.blur(context, BlurHelper.getViewBitmap(view, scaledRatio, fullScreen, cutoutX, cutoutY), view.getWidth(), view.getHeight(), radius);
    }

    public static Bitmap blur(Context context, Bitmap origin, int resultWidth, int resultHeight, float radius) {
        startTime = System.currentTimeMillis();
        if (BlurHelper.renderScriptSupported()) {
            PopupLog.i(TAG, "\u811a\u672c\u6a21\u7cca");
            return BlurHelper.scriptBlur(context, origin, resultWidth, resultHeight, radius);
        }
        PopupLog.i(TAG, "\u5feb\u901f\u6a21\u7cca");
        return BlurHelper.fastBlur(context, origin, resultWidth, resultHeight, radius);
    }

    @TargetApi(value=17)
    public static Bitmap scriptBlur(Context context, Bitmap origin, int outWidth, int outHeight, float radius) {
        ScriptIntrinsicBlur blur;
        Allocation blurOutput;
        Allocation blurInput;
        block5: {
            if (origin == null || origin.isRecycled()) {
                return null;
            }
            RenderScript renderScript = BlurHelper.getScriptInstance(context);
            blurInput = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)origin);
            blurOutput = Allocation.createTyped((RenderScript)renderScript, (Type)blurInput.getType());
            blur = null;
            try {
                blur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)blurInput.getElement());
            }
            catch (RSIllegalArgumentException e) {
                if (e.getMessage() == null || !e.getMessage().contains("Unsuported element type")) break block5;
                blur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            }
        }
        if (blur == null) {
            PopupLog.e(TAG, "\u811a\u672c\u6a21\u7cca\u5931\u8d25\uff0c\u8f6cfastBlur");
            blurInput.destroy();
            blurOutput.destroy();
            return BlurHelper.fastBlur(context, origin, outWidth, outHeight, radius);
        }
        blur.setRadius(BlurHelper.range(radius, 0.0f, 20.0f));
        blur.setInput(blurInput);
        blur.forEach(blurOutput);
        blurOutput.copyTo(origin);
        blurInput.destroy();
        blurOutput.destroy();
        Bitmap result = Bitmap.createScaledBitmap((Bitmap)origin, (int)outWidth, (int)outHeight, (boolean)true);
        origin.recycle();
        long time = System.currentTimeMillis() - startTime;
        if (PopupLog.isOpenLog()) {
            BlurHelper.toast(context, "\u6a21\u7cca\u7528\u65f6\uff1a\u3010" + time + "ms\u3011");
        }
        PopupLog.i(TAG, "\u6a21\u7cca\u7528\u65f6\uff1a\u3010" + time + "ms\u3011");
        return result;
    }

    public static Bitmap fastBlur(Context context, Bitmap origin, int outWidth, int outHeight, float radius) {
        if (origin == null || origin.isRecycled()) {
            return null;
        }
        if ((origin = FastBlur.doBlur(origin, (int)BlurHelper.range(radius, 0.0f, 20.0f), false)) == null || origin.isRecycled()) {
            return null;
        }
        origin = Bitmap.createScaledBitmap((Bitmap)origin, (int)outWidth, (int)outHeight, (boolean)true);
        long time = System.currentTimeMillis() - startTime;
        if (PopupLog.isOpenLog()) {
            BlurHelper.toast(context, "\u6a21\u7cca\u7528\u65f6\uff1a\u3010" + time + "ms\u3011");
        }
        PopupLog.i(TAG, "\u6a21\u7cca\u7528\u65f6\uff1a\u3010" + time + "ms\u3011");
        return origin;
    }

    public static Bitmap getViewBitmap(View v, boolean fullScreen) {
        return BlurHelper.getViewBitmap(v, 1.0f, fullScreen, 0, 0);
    }

    public static Bitmap getViewBitmap(View v, float scaledRatio, boolean fullScreen, int cutoutX, int cutoutY) {
        Bitmap b;
        if (v == null || v.getWidth() <= 0 || v.getHeight() <= 0) {
            PopupLog.e("getViewBitmap  >>  \u5bbd\u6216\u8005\u9ad8\u4e3a\u7a7a", new Object[0]);
            return null;
        }
        int statusBarHeight = PopupUiUtils.getStatusBarHeight();
        PopupLog.i("\u6a21\u7cca\u539f\u59cb\u56fe\u50cf\u5206\u8fa8\u7387 [" + v.getWidth() + " x " + v.getHeight() + "]");
        try {
            b = Bitmap.createBitmap((int)((int)((float)v.getWidth() * scaledRatio)), (int)((int)((float)v.getHeight() * scaledRatio)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError error) {
            System.gc();
            return null;
        }
        Canvas c = new Canvas(b);
        Matrix matrix = new Matrix();
        matrix.preScale(scaledRatio, scaledRatio);
        c.setMatrix(matrix);
        Drawable bgDrawable = v.getBackground();
        if (bgDrawable == null) {
            c.drawColor(Color.parseColor((String)"#FAFAFA"));
        } else {
            bgDrawable.draw(c);
        }
        if (fullScreen && statusBarHeight > 0 && Build.VERSION.SDK_INT >= 21 && v.getContext() instanceof Activity) {
            int statusBarColor = ((Activity)v.getContext()).getWindow().getStatusBarColor();
            Paint p = new Paint(1);
            p.setColor(statusBarColor);
            Rect rect = new Rect(0, 0, v.getWidth(), statusBarHeight);
            c.drawRect(rect, p);
        }
        v.draw(c);
        PopupLog.i("\u6a21\u7cca\u7f29\u653e\u56fe\u50cf\u5206\u8fa8\u7387 [" + b.getWidth() + " x " + b.getHeight() + "]");
        if (cutoutX > 0 || cutoutY > 0) {
            try {
                int cutLeft = (int)((float)cutoutX * scaledRatio);
                int cutTop = (int)((float)cutoutY * scaledRatio);
                int cutWidth = b.getWidth() - cutLeft;
                int cutHeight = b.getHeight() - cutTop;
                b = Bitmap.createBitmap((Bitmap)b, (int)cutLeft, (int)cutTop, (int)cutWidth, (int)cutHeight, null, (boolean)false);
            }
            catch (Exception e) {
                System.gc();
            }
        }
        return b;
    }

    public static float range(float value, float min, float max) {
        return Math.max(min, Math.min(value, max));
    }

    private static void toast(final Context context, final String msg) {
        if (Looper.myLooper() == null || Looper.myLooper() != Looper.getMainLooper()) {
            if (context instanceof Activity) {
                ((Activity)context).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BlurHelper.toast(context, msg);
                    }
                });
            }
        } else {
            Toast.makeText((Context)context.getApplicationContext(), (CharSequence)msg, (int)0).show();
        }
    }
}

