/*
 * Decompiled with CFR 0.152.
 */
package com.rockerhieu.emojicon;

import android.app.Activity;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.rockerhieu.emojicon.EmojiAdapter;
import com.rockerhieu.emojicon.EmojiconRecents;
import com.rockerhieu.emojicon.R;
import com.rockerhieu.emojicon.emoji.Emojicon;
import com.rockerhieu.emojicon.emoji.People;

public class EmojiconGridFragment
extends Fragment
implements AdapterView.OnItemClickListener {
    private OnEmojiconClickedListener mOnEmojiconClickedListener;
    private EmojiconRecents mRecents;
    private Emojicon[] mData;
    private boolean mUseSystemDefault = false;
    private static final String USE_SYSTEM_DEFAULT_KEY = "useSystemDefaults";
    private static final String EMOJICONS_KEY = "emojicons";

    protected static EmojiconGridFragment newInstance(Emojicon[] emojicons, EmojiconRecents recents) {
        return EmojiconGridFragment.newInstance(emojicons, recents, false);
    }

    protected static EmojiconGridFragment newInstance(Emojicon[] emojicons, EmojiconRecents recents, boolean useSystemDefault) {
        EmojiconGridFragment emojiGridFragment = new EmojiconGridFragment();
        Bundle args = new Bundle();
        args.putParcelableArray(EMOJICONS_KEY, (Parcelable[])emojicons);
        args.putBoolean(USE_SYSTEM_DEFAULT_KEY, useSystemDefault);
        emojiGridFragment.setArguments(args);
        emojiGridFragment.setRecents(recents);
        return emojiGridFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.emojicon_grid, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        GridView gridView = (GridView)view.findViewById(R.id.Emoji_GridView);
        Bundle bundle = this.getArguments();
        if (bundle == null) {
            this.mData = People.DATA;
            this.mUseSystemDefault = false;
        } else {
            Parcelable[] parcels = bundle.getParcelableArray(EMOJICONS_KEY);
            this.mData = new Emojicon[parcels.length];
            for (int i = 0; i < parcels.length; ++i) {
                this.mData[i] = (Emojicon)parcels[i];
            }
            this.mUseSystemDefault = bundle.getBoolean(USE_SYSTEM_DEFAULT_KEY);
        }
        gridView.setAdapter((ListAdapter)new EmojiAdapter(view.getContext(), this.mData, this.mUseSystemDefault));
        gridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelableArray(EMOJICONS_KEY, (Parcelable[])this.mData);
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (activity instanceof OnEmojiconClickedListener) {
            this.mOnEmojiconClickedListener = (OnEmojiconClickedListener)activity;
        } else if (this.getParentFragment() instanceof OnEmojiconClickedListener) {
            this.mOnEmojiconClickedListener = (OnEmojiconClickedListener)this.getParentFragment();
        } else {
            throw new IllegalArgumentException(activity + " must implement interface " + OnEmojiconClickedListener.class.getSimpleName());
        }
    }

    public void onDetach() {
        this.mOnEmojiconClickedListener = null;
        super.onDetach();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mOnEmojiconClickedListener != null) {
            this.mOnEmojiconClickedListener.onEmojiconClicked((Emojicon)parent.getItemAtPosition(position));
        }
        if (this.mRecents != null) {
            this.mRecents.addRecentEmoji(view.getContext(), (Emojicon)parent.getItemAtPosition(position));
        }
    }

    private void setRecents(EmojiconRecents recents) {
        this.mRecents = recents;
    }

    public static interface OnEmojiconClickedListener {
        public void onEmojiconClicked(Emojicon var1);
    }
}

