/*
 * Decompiled with CFR 0.152.
 */
package com.rockerhieu.emojicon;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.rockerhieu.emojicon.EmojiAdapter;
import com.rockerhieu.emojicon.EmojiconGridFragment;
import com.rockerhieu.emojicon.EmojiconRecents;
import com.rockerhieu.emojicon.EmojiconRecentsManager;
import com.rockerhieu.emojicon.R;
import com.rockerhieu.emojicon.emoji.Emojicon;

public class EmojiconRecentsGridFragment
extends EmojiconGridFragment
implements EmojiconRecents {
    private EmojiAdapter mAdapter;
    private boolean mUseSystemDefault = false;
    private static final String USE_SYSTEM_DEFAULT_KEY = "useSystemDefaults";

    protected static EmojiconRecentsGridFragment newInstance() {
        return EmojiconRecentsGridFragment.newInstance(false);
    }

    protected static EmojiconRecentsGridFragment newInstance(boolean useSystemDefault) {
        EmojiconRecentsGridFragment fragment = new EmojiconRecentsGridFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean(USE_SYSTEM_DEFAULT_KEY, useSystemDefault);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mUseSystemDefault = this.getArguments() != null ? this.getArguments().getBoolean(USE_SYSTEM_DEFAULT_KEY) : false;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        EmojiconRecentsManager recents = EmojiconRecentsManager.getInstance(view.getContext());
        this.mAdapter = new EmojiAdapter(view.getContext(), recents, this.mUseSystemDefault);
        GridView gridView = (GridView)view.findViewById(R.id.Emoji_GridView);
        gridView.setAdapter((ListAdapter)this.mAdapter);
        gridView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mAdapter = null;
    }

    @Override
    public void addRecentEmoji(Context context, Emojicon emojicon) {
        EmojiconRecentsManager recents = EmojiconRecentsManager.getInstance(context);
        recents.push(emojicon);
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }
}

