/*
 * Decompiled with CFR 0.152.
 */
package com.rockerhieu.emojicon;

import android.content.Context;
import android.content.SharedPreferences;
import com.rockerhieu.emojicon.emoji.Emojicon;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class EmojiconRecentsManager
extends ArrayList<Emojicon> {
    private static final String DELIMITER = ",";
    private static final String PREFERENCE_NAME = "emojicon";
    private static final String PREF_RECENTS = "recent_emojis";
    private static final String PREF_PAGE = "recent_page";
    private static final Object LOCK = new Object();
    private static EmojiconRecentsManager sInstance;
    private static int maximumSize;
    private Context mContext;

    private EmojiconRecentsManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.loadRecents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmojiconRecentsManager getInstance(Context context) {
        if (sInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new EmojiconRecentsManager(context);
                }
            }
        }
        return sInstance;
    }

    public int getRecentPage() {
        return this.getPreferences().getInt(PREF_PAGE, 0);
    }

    public void setRecentPage(int page) {
        this.getPreferences().edit().putInt(PREF_PAGE, page).commit();
    }

    public void push(Emojicon object) {
        if (this.contains(object)) {
            super.remove(object);
        }
        this.add(0, object);
    }

    @Override
    public boolean add(Emojicon object) {
        boolean ret = super.add(object);
        while (this.size() > maximumSize) {
            super.remove(0);
        }
        this.saveRecents();
        return ret;
    }

    @Override
    public void add(int index, Emojicon object) {
        super.add(index, object);
        if (index == 0) {
            while (this.size() > maximumSize) {
                super.remove(maximumSize);
            }
        } else {
            while (this.size() > maximumSize) {
                super.remove(0);
            }
        }
        this.saveRecents();
    }

    @Override
    public boolean remove(Object object) {
        boolean ret = super.remove(object);
        this.saveRecents();
        return ret;
    }

    private SharedPreferences getPreferences() {
        return this.mContext.getSharedPreferences(PREFERENCE_NAME, 0);
    }

    private void loadRecents() {
        SharedPreferences prefs = this.getPreferences();
        String str = prefs.getString(PREF_RECENTS, "");
        StringTokenizer tokenizer = new StringTokenizer(str, DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            this.add(Emojicon.fromChars(tokenizer.nextToken()));
        }
    }

    private void saveRecents() {
        StringBuilder str = new StringBuilder();
        int c = this.size();
        for (int i = 0; i < c; ++i) {
            Emojicon e = (Emojicon)this.get(i);
            str.append(e.getEmoji());
            if (i >= c - 1) continue;
            str.append(DELIMITER);
        }
        SharedPreferences prefs = this.getPreferences();
        prefs.edit().putString(PREF_RECENTS, str.toString()).commit();
    }

    public static void setMaximumSize(int maximumSize) {
        EmojiconRecentsManager.maximumSize = maximumSize;
    }

    static {
        maximumSize = 40;
    }
}

