/*
 * Decompiled with CFR 0.152.
 */
package com.rockerhieu.emojicon;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.rockerhieu.emojicon.EmojiconGridFragment;
import com.rockerhieu.emojicon.EmojiconRecents;
import com.rockerhieu.emojicon.EmojiconRecentsGridFragment;
import com.rockerhieu.emojicon.EmojiconRecentsManager;
import com.rockerhieu.emojicon.R;
import com.rockerhieu.emojicon.emoji.Emojicon;
import com.rockerhieu.emojicon.emoji.Nature;
import com.rockerhieu.emojicon.emoji.Objects;
import com.rockerhieu.emojicon.emoji.People;
import com.rockerhieu.emojicon.emoji.Places;
import com.rockerhieu.emojicon.emoji.Symbols;
import java.util.Arrays;
import java.util.List;

public class EmojiconsFragment
extends Fragment
implements ViewPager.OnPageChangeListener,
EmojiconRecents {
    private OnEmojiconBackspaceClickedListener mOnEmojiconBackspaceClickedListener;
    private int mEmojiTabLastSelectedIndex = -1;
    private View[] mEmojiTabs;
    private PagerAdapter mEmojisAdapter;
    private EmojiconRecentsManager mRecentsManager;
    private boolean mUseSystemDefault = false;
    private static final String USE_SYSTEM_DEFAULT_KEY = "useSystemDefaults";

    public static EmojiconsFragment newInstance(boolean useSystemDefault) {
        EmojiconsFragment fragment = new EmojiconsFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean(USE_SYSTEM_DEFAULT_KEY, useSystemDefault);
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.emojicons, container, false);
        final ViewPager emojisPager = (ViewPager)view.findViewById(R.id.emojis_pager);
        emojisPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        EmojiconsFragment recents = this;
        this.mEmojisAdapter = new EmojisPagerAdapter(this.getFragmentManager(), Arrays.asList(EmojiconRecentsGridFragment.newInstance(this.mUseSystemDefault), EmojiconGridFragment.newInstance(People.DATA, recents, this.mUseSystemDefault), EmojiconGridFragment.newInstance(Nature.DATA, recents, this.mUseSystemDefault), EmojiconGridFragment.newInstance(Objects.DATA, recents, this.mUseSystemDefault), EmojiconGridFragment.newInstance(Places.DATA, recents, this.mUseSystemDefault), EmojiconGridFragment.newInstance(Symbols.DATA, recents, this.mUseSystemDefault)));
        emojisPager.setAdapter(this.mEmojisAdapter);
        this.mEmojiTabs = new View[6];
        this.mEmojiTabs[0] = view.findViewById(R.id.emojis_tab_0_recents);
        this.mEmojiTabs[1] = view.findViewById(R.id.emojis_tab_1_people);
        this.mEmojiTabs[2] = view.findViewById(R.id.emojis_tab_2_nature);
        this.mEmojiTabs[3] = view.findViewById(R.id.emojis_tab_3_objects);
        this.mEmojiTabs[4] = view.findViewById(R.id.emojis_tab_4_cars);
        this.mEmojiTabs[5] = view.findViewById(R.id.emojis_tab_5_punctuation);
        for (int i = 0; i < this.mEmojiTabs.length; ++i) {
            final int position = i;
            this.mEmojiTabs[i].setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    emojisPager.setCurrentItem(position);
                }
            });
        }
        view.findViewById(R.id.emojis_backspace).setOnTouchListener((View.OnTouchListener)new RepeatListener(1000, 50, new View.OnClickListener(){

            public void onClick(View v) {
                if (EmojiconsFragment.this.mOnEmojiconBackspaceClickedListener != null) {
                    EmojiconsFragment.this.mOnEmojiconBackspaceClickedListener.onEmojiconBackspaceClicked(v);
                }
            }
        }));
        this.mRecentsManager = EmojiconRecentsManager.getInstance(view.getContext());
        int page = this.mRecentsManager.getRecentPage();
        if (page == 0 && this.mRecentsManager.size() == 0) {
            page = 1;
        }
        if (page == 0) {
            this.onPageSelected(page);
        } else {
            emojisPager.setCurrentItem(page, false);
        }
        return view;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (this.getActivity() instanceof OnEmojiconBackspaceClickedListener) {
            this.mOnEmojiconBackspaceClickedListener = (OnEmojiconBackspaceClickedListener)this.getActivity();
        } else if (this.getParentFragment() instanceof OnEmojiconBackspaceClickedListener) {
            this.mOnEmojiconBackspaceClickedListener = (OnEmojiconBackspaceClickedListener)this.getParentFragment();
        } else {
            throw new IllegalArgumentException(activity + " must implement interface " + OnEmojiconBackspaceClickedListener.class.getSimpleName());
        }
    }

    public void onDetach() {
        this.mOnEmojiconBackspaceClickedListener = null;
        super.onDetach();
    }

    public static void input(EditText editText, Emojicon emojicon) {
        if (editText == null || emojicon == null) {
            return;
        }
        int start = editText.getSelectionStart();
        int end = editText.getSelectionEnd();
        if (start < 0) {
            editText.append((CharSequence)emojicon.getEmoji());
        } else {
            editText.getText().replace(Math.min(start, end), Math.max(start, end), (CharSequence)emojicon.getEmoji(), 0, emojicon.getEmoji().length());
        }
    }

    @Override
    public void addRecentEmoji(Context context, Emojicon emojicon) {
        ViewPager emojisPager = (ViewPager)this.getView().findViewById(R.id.emojis_pager);
        EmojiconRecentsGridFragment fragment = (EmojiconRecentsGridFragment)this.mEmojisAdapter.instantiateItem((ViewGroup)emojisPager, 0);
        fragment.addRecentEmoji(context, emojicon);
    }

    public static void backspace(EditText editText) {
        KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
        editText.dispatchKeyEvent(event);
    }

    public void onPageScrolled(int i, float v, int i2) {
    }

    public void onPageSelected(int i) {
        if (this.mEmojiTabLastSelectedIndex == i) {
            return;
        }
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.mEmojiTabLastSelectedIndex >= 0 && this.mEmojiTabLastSelectedIndex < this.mEmojiTabs.length) {
                    this.mEmojiTabs[this.mEmojiTabLastSelectedIndex].setSelected(false);
                }
                this.mEmojiTabs[i].setSelected(true);
                this.mEmojiTabLastSelectedIndex = i;
                this.mRecentsManager.setRecentPage(i);
            }
        }
    }

    public void onPageScrollStateChanged(int i) {
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mUseSystemDefault = this.getArguments() != null ? this.getArguments().getBoolean(USE_SYSTEM_DEFAULT_KEY) : false;
    }

    public static interface OnEmojiconBackspaceClickedListener {
        public void onEmojiconBackspaceClicked(View var1);
    }

    public static class RepeatListener
    implements View.OnTouchListener {
        private Handler handler = new Handler();
        private int initialInterval;
        private final int normalInterval;
        private final View.OnClickListener clickListener;
        private Runnable handlerRunnable = new Runnable(){

            @Override
            public void run() {
                if (RepeatListener.this.downView == null) {
                    return;
                }
                RepeatListener.this.handler.removeCallbacksAndMessages((Object)RepeatListener.this.downView);
                RepeatListener.this.handler.postAtTime((Runnable)this, (Object)RepeatListener.this.downView, SystemClock.uptimeMillis() + (long)RepeatListener.this.normalInterval);
                RepeatListener.this.clickListener.onClick(RepeatListener.this.downView);
            }
        };
        private View downView;

        public RepeatListener(int initialInterval, int normalInterval, View.OnClickListener clickListener) {
            if (clickListener == null) {
                throw new IllegalArgumentException("null runnable");
            }
            if (initialInterval < 0 || normalInterval < 0) {
                throw new IllegalArgumentException("negative interval");
            }
            this.initialInterval = initialInterval;
            this.normalInterval = normalInterval;
            this.clickListener = clickListener;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            switch (motionEvent.getAction()) {
                case 0: {
                    this.downView = view;
                    this.handler.removeCallbacks(this.handlerRunnable);
                    this.handler.postAtTime(this.handlerRunnable, (Object)this.downView, SystemClock.uptimeMillis() + (long)this.initialInterval);
                    this.clickListener.onClick(view);
                    return true;
                }
                case 1: 
                case 3: 
                case 4: {
                    this.handler.removeCallbacksAndMessages((Object)this.downView);
                    this.downView = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static class EmojisPagerAdapter
    extends FragmentStatePagerAdapter {
        private List<EmojiconGridFragment> fragments;

        public EmojisPagerAdapter(FragmentManager fm, List<EmojiconGridFragment> fragments) {
            super(fm);
            this.fragments = fragments;
        }

        public Fragment getItem(int i) {
            return this.fragments.get(i);
        }

        public int getCount() {
            return this.fragments.size();
        }
    }
}

