/*
 * Decompiled with CFR 0.152.
 */
package com.rockerhieu.emojicon.emoji;

import android.os.Parcel;
import android.os.Parcelable;

public class Emojicon
implements Parcelable {
    public static final Parcelable.Creator<Emojicon> CREATOR = new Parcelable.Creator<Emojicon>(){

        public Emojicon createFromParcel(Parcel in) {
            return new Emojicon(in);
        }

        public Emojicon[] newArray(int size) {
            return new Emojicon[size];
        }
    };
    private int icon;
    private char value;
    private String emoji;

    public Emojicon(int icon, char value, String emoji) {
        this.icon = icon;
        this.value = value;
        this.emoji = emoji;
    }

    public Emojicon(Parcel in) {
        this.icon = in.readInt();
        this.value = (char)in.readInt();
        this.emoji = in.readString();
    }

    private Emojicon() {
    }

    public Emojicon(String emoji) {
        this.emoji = emoji;
    }

    public static Emojicon fromResource(int icon, int value) {
        Emojicon emoji = new Emojicon();
        emoji.icon = icon;
        emoji.value = (char)value;
        return emoji;
    }

    public static Emojicon fromCodePoint(int codePoint) {
        Emojicon emoji = new Emojicon();
        emoji.emoji = Emojicon.newString(codePoint);
        return emoji;
    }

    public static Emojicon fromChar(char ch) {
        Emojicon emoji = new Emojicon();
        emoji.emoji = Character.toString(ch);
        return emoji;
    }

    public static Emojicon fromChars(String chars) {
        Emojicon emoji = new Emojicon();
        emoji.emoji = chars;
        return emoji;
    }

    public static final String newString(int codePoint) {
        if (Character.charCount(codePoint) == 1) {
            return String.valueOf(codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.icon);
        dest.writeInt((int)this.value);
        dest.writeString(this.emoji);
    }

    public char getValue() {
        return this.value;
    }

    public int getIcon() {
        return this.icon;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public boolean equals(Object o) {
        return o instanceof Emojicon && this.emoji.equals(((Emojicon)o).emoji);
    }

    public int hashCode() {
        return this.emoji.hashCode();
    }
}

