/*
 * Decompiled with CFR 0.152.
 */
package io.github.yedaxia.apidocs.parser;

import io.github.yedaxia.apidocs.Utils;
import io.github.yedaxia.apidocs.parser.FieldNode;
import io.github.yedaxia.apidocs.parser.GenericNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassNode {
    private String className = "";
    private String description;
    private Boolean isList = Boolean.FALSE;
    private List<FieldNode> childNodes = new ArrayList<FieldNode>();
    private List<GenericNode> genericNodes = new ArrayList<GenericNode>();
    private ClassNode parentNode;
    private String classFileName;
    private Boolean showFieldNotNull = Boolean.FALSE;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean isList() {
        return this.isList;
    }

    public void setList(Boolean list) {
        this.isList = list;
    }

    public List<FieldNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(List<FieldNode> childNodes) {
        this.childNodes = childNodes;
    }

    public void addChildNode(FieldNode fieldNode) {
        this.childNodes.add(fieldNode);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<GenericNode> getGenericNodes() {
        return this.genericNodes;
    }

    public void setGenericNodes(List<GenericNode> genericNodes) {
        this.genericNodes = genericNodes;
    }

    public void addGenericNode(GenericNode genericNode) {
        this.genericNodes.add(genericNode);
    }

    public GenericNode getGenericNode(int index) {
        return this.genericNodes.get(index);
    }

    public String getClassFileName() {
        return this.classFileName;
    }

    public void setClassFileName(String classFileName) {
        this.classFileName = classFileName;
    }

    public ClassNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(ClassNode parentNode) {
        this.parentNode = parentNode;
    }

    public Boolean getShowFieldNotNull() {
        return this.showFieldNotNull;
    }

    public void setShowFieldNotNull(Boolean showFieldNotNull) {
        this.showFieldNotNull = showFieldNotNull;
    }

    public GenericNode getGenericNode(String type) {
        for (GenericNode genericNode : this.genericNodes) {
            if (!genericNode.getPlaceholder().equals(type)) continue;
            return genericNode;
        }
        return null;
    }

    public String toJsonApi() {
        if (this.childNodes == null || this.childNodes.isEmpty()) {
            return this.isList != false ? this.className + "[]" : this.className + "{}";
        }
        LinkedHashMap<String, Object> jsonRootMap = new LinkedHashMap<String, Object>();
        for (FieldNode fieldNode : this.childNodes) {
            this.toJsonApiMap(fieldNode, jsonRootMap);
        }
        if (this.isList.booleanValue()) {
            return Utils.toPrettyJson(new Map[]{jsonRootMap});
        }
        return Utils.toPrettyJson(jsonRootMap);
    }

    private void toJsonApiMap(FieldNode fieldNode, Map<String, Object> map) {
        if (fieldNode.getLoopNode().booleanValue()) {
            map.put(fieldNode.getName(), this.getFieldDesc(fieldNode));
            return;
        }
        ClassNode thisFieldNode = fieldNode.getChildNode();
        if (thisFieldNode != null) {
            LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
            for (FieldNode childFieldNode : thisFieldNode.getChildNodes()) {
                if (childFieldNode.getChildNode() != null) {
                    this.toJsonApiMap(childFieldNode, childMap);
                    continue;
                }
                childMap.put(childFieldNode.getName(), this.getFieldDesc(childFieldNode));
            }
            if (fieldNode.getType().endsWith("[]")) {
                Map[] mapArray;
                String string = fieldNode.getName();
                if (childMap.isEmpty()) {
                    mapArray = new Map[]{};
                } else {
                    Map[] mapArray2 = new Map[1];
                    mapArray = mapArray2;
                    mapArray2[0] = childMap;
                }
                map.put(string, mapArray);
            } else {
                map.put(fieldNode.getName(), childMap);
            }
        } else {
            map.put(fieldNode.getName(), this.getFieldDesc(fieldNode));
        }
    }

    private String getFieldDesc(FieldNode fieldNode) {
        String fieldType = fieldNode.getLoopNode() != false ? fieldNode.getChildNode().getClassName() + "{}" : fieldNode.getType();
        String fieldDesc = "";
        fieldDesc = Utils.isNotEmpty(fieldNode.getDescription()) ? String.format("%s //%s", fieldType, fieldNode.getDescription()) : fieldType;
        if (this.showFieldNotNull.booleanValue() && fieldNode.getNotNull().booleanValue()) {
            fieldDesc = fieldDesc + "\u3010\u5fc5\u987b\u3011";
        }
        return fieldDesc;
    }
}

