/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import io.gravitee.common.util.ChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ObservableCollection<T>
implements Collection<T> {
    private final Collection<T> wrapped;
    private final List<ChangeListener<T>> listeners = new ArrayList<ChangeListener<T>>();

    public ObservableCollection(Collection<T> wrapped) {
        Objects.requireNonNull(wrapped, "Observed collection can not be null");
        this.wrapped = wrapped;
    }

    public void addListener(ChangeListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.wrapped.toArray(a);
    }

    @Override
    public boolean add(T t) {
        this.listeners.forEach(listener -> listener.preAdd(t));
        boolean added = this.wrapped.add(t);
        if (added) {
            this.listeners.forEach(listener -> listener.postAdd(t));
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        this.listeners.forEach(listener -> listener.preRemove(o));
        boolean removed = this.wrapped.remove(o);
        if (removed) {
            this.listeners.forEach(listener -> listener.postRemove(o));
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.wrapped.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrapped.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.wrapped.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(c);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.wrapped.equals(o);
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.wrapped.spliterator();
    }

    @Override
    public Stream<T> stream() {
        return this.wrapped.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.wrapped.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.wrapped.forEach(action);
    }
}

