/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import io.gravitee.common.util.ChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ObservableSet<T>
implements Set<T> {
    private final Set<T> collections;
    private final List<ChangeListener<T>> listeners = new ArrayList<ChangeListener<T>>();

    public ObservableSet(Set<T> collections) {
        Objects.requireNonNull(collections, "Observed collection can not be null");
        this.collections = collections;
    }

    public void addListener(ChangeListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int size() {
        return this.collections.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collections.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collections.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.collections.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.collections.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collections.toArray(a);
    }

    @Override
    public boolean add(T t) {
        this.listeners.forEach(listener -> listener.preAdd(t));
        boolean added = this.collections.add(t);
        if (added) {
            this.listeners.forEach(listener -> listener.postAdd(t));
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        this.listeners.forEach(listener -> listener.preRemove(o));
        boolean removed = this.collections.remove(o);
        if (removed) {
            this.listeners.forEach(listener -> listener.postRemove(o));
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collections.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.collections.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.collections.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.collections.removeAll(c);
    }

    @Override
    public void clear() {
        this.collections.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.collections.equals(o);
    }

    @Override
    public int hashCode() {
        return this.collections.hashCode();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.collections.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.collections.removeIf(filter);
    }

    @Override
    public Stream<T> stream() {
        return this.collections.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.collections.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.collections.forEach(action);
    }
}

