/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public final class EnvironmentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentUtils.class);

    public static Map<String, Object> getPropertiesStartingWith(ConfigurableEnvironment aEnv, String aKeyPrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = EnvironmentUtils.getAllProperties(aEnv);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!EnvironmentUtils.encodedKey(key).startsWith(EnvironmentUtils.encodedKey(aKeyPrefix))) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static Object get(String key, Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map.get(EnvironmentUtils.encodedKey(key));
    }

    public static String encodedKey(String key) {
        return key.replaceAll("\\.", "_").replaceAll("\\[", "_").replaceAll("\\]", "").toUpperCase();
    }

    public static Map<String, Object> getAllProperties(ConfigurableEnvironment aEnv) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        aEnv.getPropertySources().forEach(ps -> EnvironmentUtils.addAll(result, EnvironmentUtils.getAllProperties(ps)));
        return result;
    }

    public static Map<String, Object> getAllProperties(PropertySource<?> aPropSource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (aPropSource instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)aPropSource;
            cps.getPropertySources().forEach(ps -> EnvironmentUtils.addAll(result, EnvironmentUtils.getAllProperties(ps)));
            return result;
        }
        if (aPropSource instanceof EnumerablePropertySource) {
            EnumerablePropertySource ps2 = (EnumerablePropertySource)aPropSource;
            Arrays.asList(ps2.getPropertyNames()).forEach(key -> result.put((String)key, ps2.getProperty(key)));
            return result;
        }
        LOGGER.debug("Given PropertySource is instanceof " + aPropSource.getClass().getName() + " and cannot be iterated");
        return result;
    }

    private static void addAll(Map<String, Object> aBase, Map<String, Object> aToBeAdded) {
        for (Map.Entry<String, Object> entry : aToBeAdded.entrySet()) {
            if (aBase.containsKey(entry.getKey())) continue;
            aBase.put(entry.getKey(), entry.getValue());
        }
    }
}

