/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.service.monitoring;

import io.gravitee.common.service.AbstractService;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.gravitee.node.management.http.endpoint.ManagementEndpointManager;
import io.gravitee.node.service.monitoring.MonitoringThread;
import io.gravitee.node.service.monitoring.management.MonitorManagementEndpoint;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MonitoringService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringService.class);
    @Value(value="${services.monitoring.enabled:true}")
    private boolean enabled;
    @Value(value="${services.monitoring.delay:5000}")
    private int delay;
    @Value(value="${services.monitoring.unit:MILLISECONDS}")
    private TimeUnit unit;
    private ExecutorService executorService;
    @Autowired
    private MonitorManagementEndpoint monitorManagementEndpoint;
    @Autowired
    private ManagementEndpointManager managementEndpointManager;

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            this.executorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "node-monitor"));
            MonitoringThread monitorThread = new MonitoringThread();
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)monitorThread);
            LOGGER.info("Node monitoring scheduled with fixed delay {} {} ", (Object)this.delay, (Object)this.unit.name());
            ((ScheduledExecutorService)this.executorService).scheduleWithFixedDelay(monitorThread, 0L, this.delay, this.unit);
            this.managementEndpointManager.register((ManagementEndpoint)this.monitorManagementEndpoint);
        }
    }

    protected void doStop() throws Exception {
        if (this.enabled) {
            if (!this.executorService.isShutdown()) {
                LOGGER.info("Stop node monitor");
                this.executorService.shutdownNow();
            } else {
                LOGGER.info("Gateway monitor already shut-downed");
            }
            super.doStop();
            LOGGER.info("Stop node monitor : DONE");
        }
    }

    protected String name() {
        return "Monitoring Service";
    }
}

