/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.service.monitoring.probe;

import io.gravitee.node.service.monitoring.probe.Constants;
import io.gravitee.reporter.api.monitor.OsInfo;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsProbe {
    private final Logger logger = LoggerFactory.getLogger(OsProbe.class);
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getFreePhysicalMemorySize = OsProbe.getMethod("getFreePhysicalMemorySize");
    private static final Method getTotalPhysicalMemorySize = OsProbe.getMethod("getTotalPhysicalMemorySize");
    private static final Method getFreeSwapSpaceSize = OsProbe.getMethod("getFreeSwapSpaceSize");
    private static final Method getTotalSwapSpaceSize = OsProbe.getMethod("getTotalSwapSpaceSize");
    private static final Method getSystemLoadAverage = OsProbe.getMethod("getSystemLoadAverage");
    private static final Method getSystemCpuLoad = OsProbe.getMethod("getSystemCpuLoad");

    public static OsProbe getInstance() {
        return OsProbeHolder.INSTANCE;
    }

    private OsProbe() {
    }

    public long getFreePhysicalMemorySize() {
        if (getFreePhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getFreePhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public long getTotalPhysicalMemorySize() {
        if (getTotalPhysicalMemorySize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalPhysicalMemorySize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public long getFreeSwapSpaceSize() {
        if (getFreeSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getFreeSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public long getTotalSwapSpaceSize() {
        if (getTotalSwapSpaceSize == null) {
            return -1L;
        }
        try {
            return (Long)getTotalSwapSpaceSize.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public double[] getSystemLoadAverage() {
        String procLoadAvg;
        double[] loadAverage;
        if ((Constants.LINUX || Constants.FREE_BSD) && (loadAverage = OsProbe.readProcLoadavg(procLoadAvg = Constants.LINUX ? "/proc/loadavg" : "/compat/linux/proc/loadavg")) != null) {
            return loadAverage;
        }
        if (Constants.WINDOWS) {
            return null;
        }
        if (getSystemLoadAverage == null) {
            return null;
        }
        try {
            double oneMinuteLoadAverage = (Double)getSystemLoadAverage.invoke((Object)osMxBean, new Object[0]);
            return new double[]{oneMinuteLoadAverage >= 0.0 ? oneMinuteLoadAverage : -1.0, -1.0, -1.0};
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return null;
        }
    }

    private static double[] readProcLoadavg(String procLoadavg) {
        try {
            List<String> lines = Files.readAllLines(FileSystems.getDefault().getPath(procLoadavg, new String[0]));
            if (!lines.isEmpty()) {
                String[] fields = lines.get(0).split("\\s+");
                return new double[]{Double.parseDouble(fields[0]), Double.parseDouble(fields[1]), Double.parseDouble(fields[2])};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short getSystemCpuPercent() {
        if (getSystemCpuLoad == null) {
        }
        try {
            double load = (Double)getSystemCpuLoad.invoke((Object)osMxBean, new Object[0]);
            if (load >= 0.0) {
                return (short)(load * 100.0);
            }
        }
        finally {
            return -1;
        }
    }

    public OsInfo osInfo() {
        OsInfo info = new OsInfo();
        info.timestamp = System.currentTimeMillis();
        info.cpu = new OsInfo.Cpu();
        info.cpu.percent = this.getSystemCpuPercent();
        info.cpu.loadAverage = this.getSystemLoadAverage();
        info.mem = new OsInfo.Mem();
        info.mem.total = this.getTotalPhysicalMemorySize();
        info.mem.free = this.getFreePhysicalMemorySize();
        info.swap = new OsInfo.Swap();
        info.swap.total = this.getTotalSwapSpaceSize();
        info.swap.free = this.getFreeSwapSpaceSize();
        return info;
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class OsProbeHolder {
        private static final OsProbe INSTANCE = new OsProbe();

        private OsProbeHolder() {
        }
    }
}

