/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.service.monitoring.probe;

import io.gravitee.reporter.api.monitor.ProcessInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessProbe {
    private final Logger logger = LoggerFactory.getLogger(ProcessProbe.class);
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getMaxFileDescriptorCountField = ProcessProbe.getUnixMethod("getMaxFileDescriptorCount");
    private static final Method getOpenFileDescriptorCountField = ProcessProbe.getUnixMethod("getOpenFileDescriptorCount");

    public static ProcessProbe getInstance() {
        return ProcessProbeHolder.INSTANCE;
    }

    private ProcessProbe() {
    }

    public long getMaxFileDescriptorCount() {
        if (getMaxFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getMaxFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public long getOpenFileDescriptorCount() {
        if (getOpenFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getOpenFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception ex) {
            this.logger.debug("Unexpected exception", (Throwable)ex);
            return -1L;
        }
    }

    public ProcessInfo processInfo() {
        ProcessInfo info = new ProcessInfo();
        info.timestamp = System.currentTimeMillis();
        info.openFileDescriptors = this.getOpenFileDescriptorCount();
        info.maxFileDescriptors = this.getMaxFileDescriptorCount();
        return info;
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method getUnixMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.UnixOperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class ProcessProbeHolder {
        private static final ProcessProbe INSTANCE = new ProcessProbe();

        private ProcessProbeHolder() {
        }
    }
}

