/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ManagedChannelImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    @Nullable
    private Executor executor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    @Nullable
    private String userAgent;

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    @Override
    public final T intercept(ClientInterceptor ... interceptors) {
        return (T)this.intercept((List)Arrays.asList(interceptors));
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }

    @Override
    public final T userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this.thisT();
    }

    @Override
    public ManagedChannelImpl build() {
        ClientTransportFactory transportFactory = this.buildTransportFactory();
        return new ManagedChannelImpl(transportFactory, this.executor, this.userAgent, this.interceptors);
    }

    protected abstract ClientTransportFactory buildTransportFactory();
}

