/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.internal.OkHttpProtocolNegotiator;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class OkHttpTlsUpgrader {
    private static final String HTTP2_PROTOCOL_NAME = "h2";
    private static final List<Protocol> TLS_PROTOCOLS = Collections.unmodifiableList(Arrays.asList(Protocol.HTTP_2));

    public static SSLSocket upgrade(SSLSocketFactory sslSocketFactory, Socket socket, String host, int port, ConnectionSpec spec) throws IOException {
        Preconditions.checkNotNull((Object)sslSocketFactory);
        Preconditions.checkNotNull((Object)socket);
        Preconditions.checkNotNull((Object)spec);
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, host, port, true);
        spec.apply(sslSocket, false);
        if (spec.supportsTlsExtensions()) {
            String negotiatedProtocol = OkHttpProtocolNegotiator.get().negotiate(sslSocket, host, TLS_PROTOCOLS);
            Preconditions.checkState((boolean)HTTP2_PROTOCOL_NAME.equals(negotiatedProtocol), (String)"Only \"h2\" is supported, but negotiated protocol is %s", (Object[])new Object[]{negotiatedProtocol});
        }
        return sslSocket;
    }
}

