/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.CoreV1EventFluent;
import io.kubernetes.client.openapi.models.CoreV1EventSeries;
import io.kubernetes.client.openapi.models.CoreV1EventSeriesBuilder;
import io.kubernetes.client.openapi.models.CoreV1EventSeriesFluentImpl;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1EventSourceBuilder;
import io.kubernetes.client.openapi.models.V1EventSourceFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReferenceFluentImpl;
import java.time.OffsetDateTime;
import java.util.Objects;

public class CoreV1EventFluentImpl<A extends CoreV1EventFluent<A>>
extends BaseFluent<A>
implements CoreV1EventFluent<A> {
    private String action;
    private String apiVersion;
    private Integer count;
    private OffsetDateTime eventTime;
    private OffsetDateTime firstTimestamp;
    private V1ObjectReferenceBuilder involvedObject;
    private String kind;
    private OffsetDateTime lastTimestamp;
    private String message;
    private V1ObjectMetaBuilder metadata;
    private String reason;
    private V1ObjectReferenceBuilder related;
    private String reportingComponent;
    private String reportingInstance;
    private CoreV1EventSeriesBuilder series;
    private V1EventSourceBuilder source;
    private String type;

    public CoreV1EventFluentImpl() {
    }

    public CoreV1EventFluentImpl(CoreV1Event instance) {
        this.withAction(instance.getAction());
        this.withApiVersion(instance.getApiVersion());
        this.withCount(instance.getCount());
        this.withEventTime(instance.getEventTime());
        this.withFirstTimestamp(instance.getFirstTimestamp());
        this.withInvolvedObject(instance.getInvolvedObject());
        this.withKind(instance.getKind());
        this.withLastTimestamp(instance.getLastTimestamp());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withRelated(instance.getRelated());
        this.withReportingComponent(instance.getReportingComponent());
        this.withReportingInstance(instance.getReportingInstance());
        this.withSeries(instance.getSeries());
        this.withSource(instance.getSource());
        this.withType(instance.getType());
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    @Override
    public A withEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return (A)this;
    }

    @Override
    public Boolean hasEventTime() {
        return this.eventTime != null;
    }

    @Override
    public OffsetDateTime getFirstTimestamp() {
        return this.firstTimestamp;
    }

    @Override
    public A withFirstTimestamp(OffsetDateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasFirstTimestamp() {
        return this.firstTimestamp != null;
    }

    @Override
    @Deprecated
    public V1ObjectReference getInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public V1ObjectReference buildInvolvedObject() {
        return this.involvedObject != null ? this.involvedObject.build() : null;
    }

    @Override
    public A withInvolvedObject(V1ObjectReference involvedObject) {
        this._visitables.get("involvedObject").remove(this.involvedObject);
        if (involvedObject != null) {
            this.involvedObject = new V1ObjectReferenceBuilder(involvedObject);
            this._visitables.get("involvedObject").add(this.involvedObject);
        } else {
            this.involvedObject = null;
            this._visitables.get("involvedObject").remove(this.involvedObject);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInvolvedObject() {
        return this.involvedObject != null;
    }

    @Override
    public CoreV1EventFluent.InvolvedObjectNested<A> withNewInvolvedObject() {
        return new InvolvedObjectNestedImpl();
    }

    @Override
    public CoreV1EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(V1ObjectReference item) {
        return new InvolvedObjectNestedImpl(item);
    }

    @Override
    public CoreV1EventFluent.InvolvedObjectNested<A> editInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject());
    }

    @Override
    public CoreV1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : new V1ObjectReferenceBuilder().build());
    }

    @Override
    public CoreV1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(V1ObjectReference item) {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject() != null ? this.getInvolvedObject() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public OffsetDateTime getLastTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public A withLastTimestamp(OffsetDateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasLastTimestamp() {
        return this.lastTimestamp != null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public CoreV1EventFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public CoreV1EventFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public CoreV1EventFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public CoreV1EventFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public CoreV1EventFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    @Deprecated
    public V1ObjectReference getRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public V1ObjectReference buildRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public A withRelated(V1ObjectReference related) {
        this._visitables.get("related").remove(this.related);
        if (related != null) {
            this.related = new V1ObjectReferenceBuilder(related);
            this._visitables.get("related").add(this.related);
        } else {
            this.related = null;
            this._visitables.get("related").remove(this.related);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelated() {
        return this.related != null;
    }

    @Override
    public CoreV1EventFluent.RelatedNested<A> withNewRelated() {
        return new RelatedNestedImpl();
    }

    @Override
    public CoreV1EventFluent.RelatedNested<A> withNewRelatedLike(V1ObjectReference item) {
        return new RelatedNestedImpl(item);
    }

    @Override
    public CoreV1EventFluent.RelatedNested<A> editRelated() {
        return this.withNewRelatedLike(this.getRelated());
    }

    @Override
    public CoreV1EventFluent.RelatedNested<A> editOrNewRelated() {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : new V1ObjectReferenceBuilder().build());
    }

    @Override
    public CoreV1EventFluent.RelatedNested<A> editOrNewRelatedLike(V1ObjectReference item) {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : item);
    }

    @Override
    public String getReportingComponent() {
        return this.reportingComponent;
    }

    @Override
    public A withReportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
        return (A)this;
    }

    @Override
    public Boolean hasReportingComponent() {
        return this.reportingComponent != null;
    }

    @Override
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    @Override
    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return (A)this;
    }

    @Override
    public Boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    @Override
    @Deprecated
    public CoreV1EventSeries getSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public CoreV1EventSeries buildSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public A withSeries(CoreV1EventSeries series) {
        this._visitables.get("series").remove(this.series);
        if (series != null) {
            this.series = new CoreV1EventSeriesBuilder(series);
            this._visitables.get("series").add(this.series);
        } else {
            this.series = null;
            this._visitables.get("series").remove(this.series);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeries() {
        return this.series != null;
    }

    @Override
    public CoreV1EventFluent.SeriesNested<A> withNewSeries() {
        return new SeriesNestedImpl();
    }

    @Override
    public CoreV1EventFluent.SeriesNested<A> withNewSeriesLike(CoreV1EventSeries item) {
        return new SeriesNestedImpl(item);
    }

    @Override
    public CoreV1EventFluent.SeriesNested<A> editSeries() {
        return this.withNewSeriesLike(this.getSeries());
    }

    @Override
    public CoreV1EventFluent.SeriesNested<A> editOrNewSeries() {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : new CoreV1EventSeriesBuilder().build());
    }

    @Override
    public CoreV1EventFluent.SeriesNested<A> editOrNewSeriesLike(CoreV1EventSeries item) {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : item);
    }

    @Override
    @Deprecated
    public V1EventSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public V1EventSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(V1EventSource source) {
        this._visitables.get("source").remove(this.source);
        if (source != null) {
            this.source = new V1EventSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get("source").remove(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public CoreV1EventFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public CoreV1EventFluent.SourceNested<A> withNewSourceLike(V1EventSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public CoreV1EventFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public CoreV1EventFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new V1EventSourceBuilder().build());
    }

    @Override
    public CoreV1EventFluent.SourceNested<A> editOrNewSourceLike(V1EventSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreV1EventFluentImpl that = (CoreV1EventFluentImpl)o;
        if (this.action != null ? !this.action.equals(that.action) : that.action != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.eventTime != null ? !this.eventTime.equals(that.eventTime) : that.eventTime != null) {
            return false;
        }
        if (this.firstTimestamp != null ? !this.firstTimestamp.equals(that.firstTimestamp) : that.firstTimestamp != null) {
            return false;
        }
        if (this.involvedObject != null ? !this.involvedObject.equals(that.involvedObject) : that.involvedObject != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastTimestamp != null ? !this.lastTimestamp.equals(that.lastTimestamp) : that.lastTimestamp != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.related != null ? !this.related.equals(that.related) : that.related != null) {
            return false;
        }
        if (this.reportingComponent != null ? !this.reportingComponent.equals(that.reportingComponent) : that.reportingComponent != null) {
            return false;
        }
        if (this.reportingInstance != null ? !this.reportingInstance.equals(that.reportingInstance) : that.reportingInstance != null) {
            return false;
        }
        if (this.series != null ? !this.series.equals(that.series) : that.series != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.count, this.eventTime, this.firstTimestamp, this.involvedObject, this.kind, this.lastTimestamp, this.message, this.metadata, this.reason, this.related, this.reportingComponent, this.reportingInstance, this.series, this.source, this.type, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.eventTime != null) {
            sb.append("eventTime:");
            sb.append(this.eventTime + ",");
        }
        if (this.firstTimestamp != null) {
            sb.append("firstTimestamp:");
            sb.append(this.firstTimestamp + ",");
        }
        if (this.involvedObject != null) {
            sb.append("involvedObject:");
            sb.append(this.involvedObject + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.lastTimestamp != null) {
            sb.append("lastTimestamp:");
            sb.append(this.lastTimestamp + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.related != null) {
            sb.append("related:");
            sb.append(this.related + ",");
        }
        if (this.reportingComponent != null) {
            sb.append("reportingComponent:");
            sb.append(this.reportingComponent + ",");
        }
        if (this.reportingInstance != null) {
            sb.append("reportingInstance:");
            sb.append(this.reportingInstance + ",");
        }
        if (this.series != null) {
            sb.append("series:");
            sb.append(this.series + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    class InvolvedObjectNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<CoreV1EventFluent.InvolvedObjectNested<N>>
    implements CoreV1EventFluent.InvolvedObjectNested<N>,
    Nested<N> {
        V1ObjectReferenceBuilder builder;

        InvolvedObjectNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        InvolvedObjectNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CoreV1EventFluentImpl.this.withInvolvedObject(this.builder.build());
        }

        @Override
        public N endInvolvedObject() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<CoreV1EventFluent.MetadataNested<N>>
    implements CoreV1EventFluent.MetadataNested<N>,
    Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)CoreV1EventFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class RelatedNestedImpl<N>
    extends V1ObjectReferenceFluentImpl<CoreV1EventFluent.RelatedNested<N>>
    implements CoreV1EventFluent.RelatedNested<N>,
    Nested<N> {
        V1ObjectReferenceBuilder builder;

        RelatedNestedImpl(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        RelatedNestedImpl() {
            this.builder = new V1ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CoreV1EventFluentImpl.this.withRelated(this.builder.build());
        }

        @Override
        public N endRelated() {
            return this.and();
        }
    }

    class SeriesNestedImpl<N>
    extends CoreV1EventSeriesFluentImpl<CoreV1EventFluent.SeriesNested<N>>
    implements CoreV1EventFluent.SeriesNested<N>,
    Nested<N> {
        CoreV1EventSeriesBuilder builder;

        SeriesNestedImpl(CoreV1EventSeries item) {
            this.builder = new CoreV1EventSeriesBuilder(this, item);
        }

        SeriesNestedImpl() {
            this.builder = new CoreV1EventSeriesBuilder(this);
        }

        @Override
        public N and() {
            return (N)CoreV1EventFluentImpl.this.withSeries(this.builder.build());
        }

        @Override
        public N endSeries() {
            return this.and();
        }
    }

    class SourceNestedImpl<N>
    extends V1EventSourceFluentImpl<CoreV1EventFluent.SourceNested<N>>
    implements CoreV1EventFluent.SourceNested<N>,
    Nested<N> {
        V1EventSourceBuilder builder;

        SourceNestedImpl(V1EventSource item) {
            this.builder = new V1EventSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new V1EventSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CoreV1EventFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

