/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.StorageV1TokenRequest;
import io.kubernetes.client.openapi.models.StorageV1TokenRequestBuilder;
import io.kubernetes.client.openapi.models.StorageV1TokenRequestFluent;
import io.kubernetes.client.openapi.models.V1CSIDriverSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CSIDriverSpecFluent<A extends V1CSIDriverSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean attachRequired;
    private String fsGroupPolicy;
    private Long nodeAllocatableUpdatePeriodSeconds;
    private Boolean podInfoOnMount;
    private Boolean requiresRepublish;
    private Boolean seLinuxMount;
    private Boolean storageCapacity;
    private ArrayList<StorageV1TokenRequestBuilder> tokenRequests;
    private List<String> volumeLifecycleModes;

    public V1CSIDriverSpecFluent() {
    }

    public V1CSIDriverSpecFluent(V1CSIDriverSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CSIDriverSpec instance) {
        V1CSIDriverSpec v1CSIDriverSpec = instance = instance != null ? instance : new V1CSIDriverSpec();
        if (instance != null) {
            this.withAttachRequired(instance.getAttachRequired());
            this.withFsGroupPolicy(instance.getFsGroupPolicy());
            this.withNodeAllocatableUpdatePeriodSeconds(instance.getNodeAllocatableUpdatePeriodSeconds());
            this.withPodInfoOnMount(instance.getPodInfoOnMount());
            this.withRequiresRepublish(instance.getRequiresRepublish());
            this.withSeLinuxMount(instance.getSeLinuxMount());
            this.withStorageCapacity(instance.getStorageCapacity());
            this.withTokenRequests(instance.getTokenRequests());
            this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());
        }
    }

    public Boolean getAttachRequired() {
        return this.attachRequired;
    }

    public A withAttachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
        return (A)this;
    }

    public boolean hasAttachRequired() {
        return this.attachRequired != null;
    }

    public String getFsGroupPolicy() {
        return this.fsGroupPolicy;
    }

    public A withFsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy = fsGroupPolicy;
        return (A)this;
    }

    public boolean hasFsGroupPolicy() {
        return this.fsGroupPolicy != null;
    }

    public Long getNodeAllocatableUpdatePeriodSeconds() {
        return this.nodeAllocatableUpdatePeriodSeconds;
    }

    public A withNodeAllocatableUpdatePeriodSeconds(Long nodeAllocatableUpdatePeriodSeconds) {
        this.nodeAllocatableUpdatePeriodSeconds = nodeAllocatableUpdatePeriodSeconds;
        return (A)this;
    }

    public boolean hasNodeAllocatableUpdatePeriodSeconds() {
        return this.nodeAllocatableUpdatePeriodSeconds != null;
    }

    public Boolean getPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    public A withPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
        return (A)this;
    }

    public boolean hasPodInfoOnMount() {
        return this.podInfoOnMount != null;
    }

    public Boolean getRequiresRepublish() {
        return this.requiresRepublish;
    }

    public A withRequiresRepublish(Boolean requiresRepublish) {
        this.requiresRepublish = requiresRepublish;
        return (A)this;
    }

    public boolean hasRequiresRepublish() {
        return this.requiresRepublish != null;
    }

    public Boolean getSeLinuxMount() {
        return this.seLinuxMount;
    }

    public A withSeLinuxMount(Boolean seLinuxMount) {
        this.seLinuxMount = seLinuxMount;
        return (A)this;
    }

    public boolean hasSeLinuxMount() {
        return this.seLinuxMount != null;
    }

    public Boolean getStorageCapacity() {
        return this.storageCapacity;
    }

    public A withStorageCapacity(Boolean storageCapacity) {
        this.storageCapacity = storageCapacity;
        return (A)this;
    }

    public boolean hasStorageCapacity() {
        return this.storageCapacity != null;
    }

    public A addToTokenRequests(int index, StorageV1TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
        if (index < 0 || index >= this.tokenRequests.size()) {
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        } else {
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(index, builder);
        }
        return (A)this;
    }

    public A setToTokenRequests(int index, StorageV1TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
        if (index < 0 || index >= this.tokenRequests.size()) {
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        } else {
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.set(index, builder);
        }
        return (A)this;
    }

    public A addToTokenRequests(StorageV1TokenRequest ... items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)this;
    }

    public A addAllToTokenRequests(Collection<StorageV1TokenRequest> items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)this;
    }

    public A removeFromTokenRequests(StorageV1TokenRequest ... items) {
        if (this.tokenRequests == null) {
            return (A)this;
        }
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").remove(builder);
            this.tokenRequests.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTokenRequests(Collection<StorageV1TokenRequest> items) {
        if (this.tokenRequests == null) {
            return (A)this;
        }
        for (StorageV1TokenRequest item : items) {
            StorageV1TokenRequestBuilder builder = new StorageV1TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").remove(builder);
            this.tokenRequests.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTokenRequests(Predicate<StorageV1TokenRequestBuilder> predicate) {
        if (this.tokenRequests == null) {
            return (A)this;
        }
        Iterator<StorageV1TokenRequestBuilder> each = this.tokenRequests.iterator();
        Object visitables = this._visitables.get("tokenRequests");
        while (each.hasNext()) {
            StorageV1TokenRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<StorageV1TokenRequest> buildTokenRequests() {
        return this.tokenRequests != null ? V1CSIDriverSpecFluent.build(this.tokenRequests) : null;
    }

    public StorageV1TokenRequest buildTokenRequest(int index) {
        return this.tokenRequests.get(index).build();
    }

    public StorageV1TokenRequest buildFirstTokenRequest() {
        return this.tokenRequests.get(0).build();
    }

    public StorageV1TokenRequest buildLastTokenRequest() {
        return this.tokenRequests.get(this.tokenRequests.size() - 1).build();
    }

    public StorageV1TokenRequest buildMatchingTokenRequest(Predicate<StorageV1TokenRequestBuilder> predicate) {
        for (StorageV1TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTokenRequest(Predicate<StorageV1TokenRequestBuilder> predicate) {
        for (StorageV1TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTokenRequests(List<StorageV1TokenRequest> tokenRequests) {
        if (this.tokenRequests != null) {
            this._visitables.get("tokenRequests").clear();
        }
        if (tokenRequests != null) {
            this.tokenRequests = new ArrayList();
            for (StorageV1TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        } else {
            this.tokenRequests = null;
        }
        return (A)this;
    }

    public A withTokenRequests(StorageV1TokenRequest ... tokenRequests) {
        if (this.tokenRequests != null) {
            this.tokenRequests.clear();
            this._visitables.remove("tokenRequests");
        }
        if (tokenRequests != null) {
            for (StorageV1TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        }
        return (A)this;
    }

    public boolean hasTokenRequests() {
        return this.tokenRequests != null && !this.tokenRequests.isEmpty();
    }

    public TokenRequestsNested<A> addNewTokenRequest() {
        return new TokenRequestsNested(-1, null);
    }

    public TokenRequestsNested<A> addNewTokenRequestLike(StorageV1TokenRequest item) {
        return new TokenRequestsNested(-1, item);
    }

    public TokenRequestsNested<A> setNewTokenRequestLike(int index, StorageV1TokenRequest item) {
        return new TokenRequestsNested(index, item);
    }

    public TokenRequestsNested<A> editTokenRequest(int index) {
        if (this.tokenRequests.size() <= index) {
            throw new RuntimeException("Can't edit tokenRequests. Index exceeds size.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    public TokenRequestsNested<A> editFirstTokenRequest() {
        if (this.tokenRequests.size() == 0) {
            throw new RuntimeException("Can't edit first tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(0, this.buildTokenRequest(0));
    }

    public TokenRequestsNested<A> editLastTokenRequest() {
        int index = this.tokenRequests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    public TokenRequestsNested<A> editMatchingTokenRequest(Predicate<StorageV1TokenRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tokenRequests.size(); ++i) {
            if (!predicate.test(this.tokenRequests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tokenRequests. No match found.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    public A addToVolumeLifecycleModes(int index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.add(index, item);
        return (A)this;
    }

    public A setToVolumeLifecycleModes(int index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.set(index, item);
        return (A)this;
    }

    public A addToVolumeLifecycleModes(String ... items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)this;
    }

    public A addAllToVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)this;
    }

    public A removeFromVolumeLifecycleModes(String ... items) {
        if (this.volumeLifecycleModes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumeLifecycleModes.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {
            return (A)this;
        }
        for (String item : items) {
            this.volumeLifecycleModes.remove(item);
        }
        return (A)this;
    }

    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    public String getVolumeLifecycleMode(int index) {
        return this.volumeLifecycleModes.get(index);
    }

    public String getFirstVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(0);
    }

    public String getLastVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(this.volumeLifecycleModes.size() - 1);
    }

    public String getMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        if (volumeLifecycleModes != null) {
            this.volumeLifecycleModes = new ArrayList<String>();
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        } else {
            this.volumeLifecycleModes = null;
        }
        return (A)this;
    }

    public A withVolumeLifecycleModes(String ... volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) {
            this.volumeLifecycleModes.clear();
            this._visitables.remove("volumeLifecycleModes");
        }
        if (volumeLifecycleModes != null) {
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumeLifecycleModes() {
        return this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CSIDriverSpecFluent that = (V1CSIDriverSpecFluent)o;
        if (!Objects.equals(this.attachRequired, that.attachRequired)) {
            return false;
        }
        if (!Objects.equals(this.fsGroupPolicy, that.fsGroupPolicy)) {
            return false;
        }
        if (!Objects.equals(this.nodeAllocatableUpdatePeriodSeconds, that.nodeAllocatableUpdatePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.podInfoOnMount, that.podInfoOnMount)) {
            return false;
        }
        if (!Objects.equals(this.requiresRepublish, that.requiresRepublish)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxMount, that.seLinuxMount)) {
            return false;
        }
        if (!Objects.equals(this.storageCapacity, that.storageCapacity)) {
            return false;
        }
        if (!Objects.equals(this.tokenRequests, that.tokenRequests)) {
            return false;
        }
        return Objects.equals(this.volumeLifecycleModes, that.volumeLifecycleModes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachRequired, this.fsGroupPolicy, this.nodeAllocatableUpdatePeriodSeconds, this.podInfoOnMount, this.requiresRepublish, this.seLinuxMount, this.storageCapacity, this.tokenRequests, this.volumeLifecycleModes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachRequired != null) {
            sb.append("attachRequired:");
            sb.append(this.attachRequired + ",");
        }
        if (this.fsGroupPolicy != null) {
            sb.append("fsGroupPolicy:");
            sb.append(this.fsGroupPolicy + ",");
        }
        if (this.nodeAllocatableUpdatePeriodSeconds != null) {
            sb.append("nodeAllocatableUpdatePeriodSeconds:");
            sb.append(this.nodeAllocatableUpdatePeriodSeconds + ",");
        }
        if (this.podInfoOnMount != null) {
            sb.append("podInfoOnMount:");
            sb.append(this.podInfoOnMount + ",");
        }
        if (this.requiresRepublish != null) {
            sb.append("requiresRepublish:");
            sb.append(this.requiresRepublish + ",");
        }
        if (this.seLinuxMount != null) {
            sb.append("seLinuxMount:");
            sb.append(this.seLinuxMount + ",");
        }
        if (this.storageCapacity != null) {
            sb.append("storageCapacity:");
            sb.append(this.storageCapacity + ",");
        }
        if (this.tokenRequests != null && !this.tokenRequests.isEmpty()) {
            sb.append("tokenRequests:");
            sb.append(String.valueOf(this.tokenRequests) + ",");
        }
        if (this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty()) {
            sb.append("volumeLifecycleModes:");
            sb.append(this.volumeLifecycleModes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAttachRequired() {
        return this.withAttachRequired(true);
    }

    public A withPodInfoOnMount() {
        return this.withPodInfoOnMount(true);
    }

    public A withRequiresRepublish() {
        return this.withRequiresRepublish(true);
    }

    public A withSeLinuxMount() {
        return this.withSeLinuxMount(true);
    }

    public A withStorageCapacity() {
        return this.withStorageCapacity(true);
    }

    public class TokenRequestsNested<N>
    extends StorageV1TokenRequestFluent<TokenRequestsNested<N>>
    implements Nested<N> {
        StorageV1TokenRequestBuilder builder;
        int index;

        TokenRequestsNested(int index, StorageV1TokenRequest item) {
            this.index = index;
            this.builder = new StorageV1TokenRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CSIDriverSpecFluent.this.setToTokenRequests(this.index, this.builder.build());
        }

        public N endTokenRequest() {
            return this.and();
        }
    }
}

