/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CSINodeDriver;
import io.kubernetes.client.openapi.models.V1VolumeNodeResources;
import io.kubernetes.client.openapi.models.V1VolumeNodeResourcesBuilder;
import io.kubernetes.client.openapi.models.V1VolumeNodeResourcesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1CSINodeDriverFluent<A extends V1CSINodeDriverFluent<A>>
extends BaseFluent<A> {
    private V1VolumeNodeResourcesBuilder allocatable;
    private String name;
    private String nodeID;
    private List<String> topologyKeys;

    public V1CSINodeDriverFluent() {
    }

    public V1CSINodeDriverFluent(V1CSINodeDriver instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CSINodeDriver instance) {
        V1CSINodeDriver v1CSINodeDriver = instance = instance != null ? instance : new V1CSINodeDriver();
        if (instance != null) {
            this.withAllocatable(instance.getAllocatable());
            this.withName(instance.getName());
            this.withNodeID(instance.getNodeID());
            this.withTopologyKeys(instance.getTopologyKeys());
        }
    }

    public V1VolumeNodeResources buildAllocatable() {
        return this.allocatable != null ? this.allocatable.build() : null;
    }

    public A withAllocatable(V1VolumeNodeResources allocatable) {
        this._visitables.remove("allocatable");
        if (allocatable != null) {
            this.allocatable = new V1VolumeNodeResourcesBuilder(allocatable);
            this._visitables.get("allocatable").add(this.allocatable);
        } else {
            this.allocatable = null;
            this._visitables.get("allocatable").remove(this.allocatable);
        }
        return (A)this;
    }

    public boolean hasAllocatable() {
        return this.allocatable != null;
    }

    public AllocatableNested<A> withNewAllocatable() {
        return new AllocatableNested(null);
    }

    public AllocatableNested<A> withNewAllocatableLike(V1VolumeNodeResources item) {
        return new AllocatableNested(item);
    }

    public AllocatableNested<A> editAllocatable() {
        return this.withNewAllocatableLike(Optional.ofNullable(this.buildAllocatable()).orElse(null));
    }

    public AllocatableNested<A> editOrNewAllocatable() {
        return this.withNewAllocatableLike(Optional.ofNullable(this.buildAllocatable()).orElse(new V1VolumeNodeResourcesBuilder().build()));
    }

    public AllocatableNested<A> editOrNewAllocatableLike(V1VolumeNodeResources item) {
        return this.withNewAllocatableLike(Optional.ofNullable(this.buildAllocatable()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public A withNodeID(String nodeID) {
        this.nodeID = nodeID;
        return (A)this;
    }

    public boolean hasNodeID() {
        return this.nodeID != null;
    }

    public A addToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    public A setToTopologyKeys(int index, String item) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        this.topologyKeys.set(index, item);
        return (A)this;
    }

    public A addToTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            this.topologyKeys = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyKeys.add(item);
        }
        return (A)this;
    }

    public A removeFromTopologyKeys(String ... items) {
        if (this.topologyKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {
            return (A)this;
        }
        for (String item : items) {
            this.topologyKeys.remove(item);
        }
        return (A)this;
    }

    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    public String getLastTopologyKey() {
        return this.topologyKeys.get(this.topologyKeys.size() - 1);
    }

    public String getMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTopologyKey(Predicate<String> predicate) {
        for (String item : this.topologyKeys) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologyKeys(List<String> topologyKeys) {
        if (topologyKeys != null) {
            this.topologyKeys = new ArrayList<String>();
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        } else {
            this.topologyKeys = null;
        }
        return (A)this;
    }

    public A withTopologyKeys(String ... topologyKeys) {
        if (this.topologyKeys != null) {
            this.topologyKeys.clear();
            this._visitables.remove("topologyKeys");
        }
        if (topologyKeys != null) {
            for (String item : topologyKeys) {
                this.addToTopologyKeys(item);
            }
        }
        return (A)this;
    }

    public boolean hasTopologyKeys() {
        return this.topologyKeys != null && !this.topologyKeys.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CSINodeDriverFluent that = (V1CSINodeDriverFluent)o;
        if (!Objects.equals(this.allocatable, that.allocatable)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nodeID, that.nodeID)) {
            return false;
        }
        return Objects.equals(this.topologyKeys, that.topologyKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocatable, this.name, this.nodeID, this.topologyKeys, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatable != null) {
            sb.append("allocatable:");
            sb.append(String.valueOf(this.allocatable) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.nodeID != null) {
            sb.append("nodeID:");
            sb.append(this.nodeID + ",");
        }
        if (this.topologyKeys != null && !this.topologyKeys.isEmpty()) {
            sb.append("topologyKeys:");
            sb.append(this.topologyKeys);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AllocatableNested<N>
    extends V1VolumeNodeResourcesFluent<AllocatableNested<N>>
    implements Nested<N> {
        V1VolumeNodeResourcesBuilder builder;

        AllocatableNested(V1VolumeNodeResources item) {
            this.builder = new V1VolumeNodeResourcesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CSINodeDriverFluent.this.withAllocatable(this.builder.build());
        }

        public N endAllocatable() {
            return this.and();
        }
    }
}

