/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressBackendBuilder;
import io.kubernetes.client.openapi.models.V1IngressBackendFluent;
import java.util.Objects;
import java.util.Optional;

public class V1HTTPIngressPathFluent<A extends V1HTTPIngressPathFluent<A>>
extends BaseFluent<A> {
    private V1IngressBackendBuilder backend;
    private String path;
    private String pathType;

    public V1HTTPIngressPathFluent() {
    }

    public V1HTTPIngressPathFluent(V1HTTPIngressPath instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1HTTPIngressPath instance) {
        V1HTTPIngressPath v1HTTPIngressPath = instance = instance != null ? instance : new V1HTTPIngressPath();
        if (instance != null) {
            this.withBackend(instance.getBackend());
            this.withPath(instance.getPath());
            this.withPathType(instance.getPathType());
        }
    }

    public V1IngressBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    public A withBackend(V1IngressBackend backend) {
        this._visitables.remove("backend");
        if (backend != null) {
            this.backend = new V1IngressBackendBuilder(backend);
            this._visitables.get("backend").add(this.backend);
        } else {
            this.backend = null;
            this._visitables.get("backend").remove(this.backend);
        }
        return (A)this;
    }

    public boolean hasBackend() {
        return this.backend != null;
    }

    public BackendNested<A> withNewBackend() {
        return new BackendNested(null);
    }

    public BackendNested<A> withNewBackendLike(V1IngressBackend item) {
        return new BackendNested(item);
    }

    public BackendNested<A> editBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(null));
    }

    public BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(new V1IngressBackendBuilder().build()));
    }

    public BackendNested<A> editOrNewBackendLike(V1IngressBackend item) {
        return this.withNewBackendLike(Optional.ofNullable(this.buildBackend()).orElse(item));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getPathType() {
        return this.pathType;
    }

    public A withPathType(String pathType) {
        this.pathType = pathType;
        return (A)this;
    }

    public boolean hasPathType() {
        return this.pathType != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HTTPIngressPathFluent that = (V1HTTPIngressPathFluent)o;
        if (!Objects.equals(this.backend, that.backend)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.pathType, that.pathType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backend != null) {
            sb.append("backend:");
            sb.append(String.valueOf(this.backend) + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.pathType != null) {
            sb.append("pathType:");
            sb.append(this.pathType);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BackendNested<N>
    extends V1IngressBackendFluent<BackendNested<N>>
    implements Nested<N> {
        V1IngressBackendBuilder builder;

        BackendNested(V1IngressBackend item) {
            this.builder = new V1IngressBackendBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1HTTPIngressPathFluent.this.withBackend(this.builder.build());
        }

        public N endBackend() {
            return this.and();
        }
    }
}

