/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngressBuilder;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngressFluent;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1LoadBalancerStatusFluent<A extends V1LoadBalancerStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1LoadBalancerIngressBuilder> ingress;

    public V1LoadBalancerStatusFluent() {
    }

    public V1LoadBalancerStatusFluent(V1LoadBalancerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1LoadBalancerStatus instance) {
        V1LoadBalancerStatus v1LoadBalancerStatus = instance = instance != null ? instance : new V1LoadBalancerStatus();
        if (instance != null) {
            this.withIngress(instance.getIngress());
        }
    }

    public A addToIngress(int index, V1LoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    public A setToIngress(int index, V1LoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    public A addToIngress(V1LoadBalancerIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A addAllToIngress(Collection<V1LoadBalancerIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    public A removeFromIngress(V1LoadBalancerIngress ... items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromIngress(Collection<V1LoadBalancerIngress> items) {
        if (this.ingress == null) {
            return (A)this;
        }
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<V1LoadBalancerIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            V1LoadBalancerIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1LoadBalancerIngress> buildIngress() {
        return this.ingress != null ? V1LoadBalancerStatusFluent.build(this.ingress) : null;
    }

    public V1LoadBalancerIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public V1LoadBalancerIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public V1LoadBalancerIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public V1LoadBalancerIngress buildMatchingIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        for (V1LoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        for (V1LoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<V1LoadBalancerIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (V1LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    public A withIngress(V1LoadBalancerIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (V1LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(V1LoadBalancerIngress item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, V1LoadBalancerIngress item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1LoadBalancerStatusFluent that = (V1LoadBalancerStatusFluent)o;
        return Objects.equals(this.ingress, that.ingress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ingress, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IngressNested<N>
    extends V1LoadBalancerIngressFluent<IngressNested<N>>
    implements Nested<N> {
        V1LoadBalancerIngressBuilder builder;
        int index;

        IngressNested(int index, V1LoadBalancerIngress item) {
            this.index = index;
            this.builder = new V1LoadBalancerIngressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1LoadBalancerStatusFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }
}

