/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1ResourceFieldSelector;
import java.util.Objects;

public class V1ResourceFieldSelectorFluent<A extends V1ResourceFieldSelectorFluent<A>>
extends BaseFluent<A> {
    private String containerName;
    private Quantity divisor;
    private String resource;

    public V1ResourceFieldSelectorFluent() {
    }

    public V1ResourceFieldSelectorFluent(V1ResourceFieldSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ResourceFieldSelector instance) {
        V1ResourceFieldSelector v1ResourceFieldSelector = instance = instance != null ? instance : new V1ResourceFieldSelector();
        if (instance != null) {
            this.withContainerName(instance.getContainerName());
            this.withDivisor(instance.getDivisor());
            this.withResource(instance.getResource());
        }
    }

    public String getContainerName() {
        return this.containerName;
    }

    public A withContainerName(String containerName) {
        this.containerName = containerName;
        return (A)this;
    }

    public boolean hasContainerName() {
        return this.containerName != null;
    }

    public Quantity getDivisor() {
        return this.divisor;
    }

    public A withDivisor(Quantity divisor) {
        this.divisor = divisor;
        return (A)this;
    }

    public boolean hasDivisor() {
        return this.divisor != null;
    }

    public A withNewDivisor(String value) {
        return this.withDivisor(new Quantity(value));
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ResourceFieldSelectorFluent that = (V1ResourceFieldSelectorFluent)o;
        if (!Objects.equals(this.containerName, that.containerName)) {
            return false;
        }
        if (!Objects.equals(this.divisor, that.divisor)) {
            return false;
        }
        return Objects.equals(this.resource, that.resource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerName, this.divisor, this.resource, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerName != null) {
            sb.append("containerName:");
            sb.append(this.containerName + ",");
        }
        if (this.divisor != null) {
            sb.append("divisor:");
            sb.append(String.valueOf(this.divisor) + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource);
        }
        sb.append("}");
        return sb.toString();
    }
}

