/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2MetricIdentifier;
import io.kubernetes.client.openapi.models.V2MetricTarget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.")
public class V2PodsMetricSource {
    public static final String SERIALIZED_NAME_METRIC = "metric";
    @SerializedName(value="metric")
    @Nonnull
    private V2MetricIdentifier metric;
    public static final String SERIALIZED_NAME_TARGET = "target";
    @SerializedName(value="target")
    @Nonnull
    private V2MetricTarget target;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2PodsMetricSource metric(@Nonnull V2MetricIdentifier metric) {
        this.metric = metric;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V2MetricIdentifier getMetric() {
        return this.metric;
    }

    public void setMetric(@Nonnull V2MetricIdentifier metric) {
        this.metric = metric;
    }

    public V2PodsMetricSource target(@Nonnull V2MetricTarget target) {
        this.target = target;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V2MetricTarget getTarget() {
        return this.target;
    }

    public void setTarget(@Nonnull V2MetricTarget target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2PodsMetricSource v2PodsMetricSource = (V2PodsMetricSource)o;
        return Objects.equals(this.metric, v2PodsMetricSource.metric) && Objects.equals(this.target, v2PodsMetricSource.target);
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2PodsMetricSource {\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2PodsMetricSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2PodsMetricSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        V2MetricIdentifier.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METRIC));
        V2MetricTarget.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TARGET));
    }

    public static V2PodsMetricSource fromJson(String jsonString) throws IOException {
        return (V2PodsMetricSource)JSON.getGson().fromJson(jsonString, V2PodsMetricSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_METRIC);
        openapiFields.add(SERIALIZED_NAME_TARGET);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_METRIC);
        openapiRequiredFields.add(SERIALIZED_NAME_TARGET);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2PodsMetricSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2PodsMetricSource.class));
            return new TypeAdapter<V2PodsMetricSource>(){

                public void write(JsonWriter out, V2PodsMetricSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2PodsMetricSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2PodsMetricSource.validateJsonElement(jsonElement);
                    return (V2PodsMetricSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

